/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.util.Time;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Unit;
import mindustry.type.StatusEffect;

public class StatusFieldAbility
extends Ability {
    public StatusEffect effect;
    public float duration = 60.0f;
    public float reload = 100.0f;
    public float range = 20.0f;
    public Effect applyEffect = Fx.heal;
    public Effect activeEffect = Fx.overdriveWave;
    protected float timer;

    StatusFieldAbility() {
    }

    public StatusFieldAbility(StatusEffect effect, float duration, float reload, float range) {
        this.duration = duration;
        this.reload = reload;
        this.range = range;
        this.effect = effect;
    }

    @Override
    public void update(Unit unit) {
        this.timer += Time.delta;
        if (this.timer >= this.reload) {
            Units.nearby(unit.team, unit.x, unit.y, this.range, other -> other.apply(this.effect, this.duration));
            this.activeEffect.at(unit);
            this.timer = 0.0f;
        }
    }
}

