/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.math.Angles;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.type.UnitType;
import mindustry.ui.Cicon;

public class UnitSpawnAbility
extends Ability {
    public UnitType unit;
    public float spawnTime = 60.0f;
    public float spawnX;
    public float spawnY;
    public Effect spawnEffect = Fx.spawn;
    protected float timer;

    public UnitSpawnAbility(UnitType unit, float spawnTime, float spawnX, float spawnY) {
        this.unit = unit;
        this.spawnTime = spawnTime;
        this.spawnX = spawnX;
        this.spawnY = spawnY;
    }

    public UnitSpawnAbility() {
    }

    @Override
    public void update(Unit unit) {
        this.timer += Time.delta * Vars.state.rules.unitBuildSpeedMultiplier;
        if (this.timer >= this.spawnTime && Units.canCreate(unit.team, this.unit)) {
            float x = unit.x + Angles.trnsx(unit.rotation, this.spawnY, this.spawnX);
            float y = unit.y + Angles.trnsy(unit.rotation, this.spawnY, this.spawnX);
            this.spawnEffect.at(x, y);
            Unit u = this.unit.create(unit.team);
            u.set(x, y);
            u.rotation = unit.rotation;
            if (!Vars.net.client()) {
                u.add();
            }
            this.timer = 0.0f;
        }
    }

    @Override
    public void draw(Unit unit) {
        if (Units.canCreate(unit.team, this.unit)) {
            Draw.draw(Draw.z(), () -> {
                float x = unit.x + Angles.trnsx(unit.rotation, this.spawnY, this.spawnX);
                float y = unit.y + Angles.trnsy(unit.rotation, this.spawnY, this.spawnX);
                Drawf.construct(x, y, this.unit.icon(Cicon.full), unit.rotation - 90.0f, this.timer / this.spawnTime, 1.0f, this.timer);
            });
        }
    }

    @Override
    public String localized() {
        return Core.bundle.format("ability.unitspawn", this.unit.localizedName);
    }
}

