/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.graphics.g2d.Draw;
import mindustry.content.Fx;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.gen.Bullet;
import mindustry.gen.Sounds;

public class ArtilleryBulletType
extends BasicBulletType {
    public float trailMult = 1.0f;
    public float trailSize = 4.0f;

    public ArtilleryBulletType(float speed, float damage, String bulletSprite) {
        super(speed, damage, bulletSprite);
        this.collidesTiles = false;
        this.collides = false;
        this.collidesAir = false;
        this.scaleVelocity = true;
        this.hitShake = 1.0f;
        this.hitSound = Sounds.explosion;
        this.shootEffect = Fx.shootBig;
        this.trailEffect = Fx.artilleryTrail;
    }

    public ArtilleryBulletType(float speed, float damage) {
        this(speed, damage, "shell");
    }

    public ArtilleryBulletType() {
        this(1.0f, 1.0f, "shell");
    }

    @Override
    public void update(Bullet b) {
        super.update(b);
        if (b.timer(0, (3.0f + b.fslope() * 2.0f) * this.trailMult)) {
            this.trailEffect.at(b.x, b.y, b.fslope() * this.trailSize, this.backColor);
        }
    }

    @Override
    public void draw(Bullet b) {
        float baseScale = 0.7f;
        float scale = baseScale + b.fslope() * (1.0f - baseScale);
        float height = this.height * (1.0f - this.shrinkY + this.shrinkY * b.fout());
        Draw.color(this.backColor);
        Draw.rect(this.backRegion, b.x, b.y, this.width * scale, height * scale, b.rotation() - 90.0f);
        Draw.color(this.frontColor);
        Draw.rect(this.frontRegion, b.x, b.y, this.width * scale, height * scale, b.rotation() - 90.0f);
        Draw.color();
    }
}

