/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.audio.Sound;
import arc.graphics.Color;
import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Nullable;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Bullets;
import mindustry.content.Fx;
import mindustry.content.Liquids;
import mindustry.content.StatusEffects;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Fires;
import mindustry.entities.Lightning;
import mindustry.entities.Puddles;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Call;
import mindustry.gen.Entityc;
import mindustry.gen.Healthc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Velc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Liquid;
import mindustry.type.StatusEffect;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;

public abstract class BulletType
extends Content {
    public float lifetime = 40.0f;
    public float speed;
    public float damage;
    public float hitSize = 4.0f;
    public float drawSize = 40.0f;
    public float drag = 0.0f;
    public boolean pierce;
    public boolean pierceBuilding;
    public int pierceCap = -1;
    public Effect hitEffect;
    public Effect despawnEffect;
    public Effect shootEffect = Fx.shootSmall;
    public Effect smokeEffect = Fx.shootSmallSmoke;
    public Sound hitSound = Sounds.none;
    public float hitSoundPitch = 1.0f;
    public float hitSoundVolume = 1.0f;
    public float inaccuracy = 0.0f;
    public float ammoMultiplier = 2.0f;
    public float reloadMultiplier = 1.0f;
    public float buildingDamageMultiplier = 1.0f;
    public float recoil;
    public boolean killShooter;
    public boolean instantDisappear;
    public float splashDamage = 0.0f;
    public float knockback;
    public StatusEffect status = StatusEffects.none;
    public float statusDuration = 480.0f;
    public boolean collidesTiles = true;
    public boolean collidesTeam = false;
    public boolean collidesAir = true;
    public boolean collidesGround = true;
    public boolean collides = true;
    public boolean keepVelocity = true;
    public boolean scaleVelocity;
    public boolean hittable = true;
    public boolean reflectable = true;
    public boolean absorbable = true;
    public boolean backMove = true;
    public float maxRange = -1.0f;
    public float healPercent = 0.0f;
    public boolean makeFire = false;
    public float fragCone = 360.0f;
    public float fragAngle = 0.0f;
    public int fragBullets = 9;
    public float fragVelocityMin = 0.2f;
    public float fragVelocityMax = 1.0f;
    public float fragLifeMin = 1.0f;
    public float fragLifeMax = 1.0f;
    @Nullable
    public BulletType fragBullet = null;
    public Color hitColor = Color.white;
    public Color trailColor = Pal.missileYellowBack;
    public float trailChance = -1.0E-4f;
    public Effect trailEffect = Fx.missileTrail;
    public float trailParam = 2.0f;
    public float splashDamageRadius = -1.0f;
    public int incendAmount = 0;
    public float incendSpread = 8.0f;
    public float incendChance = 1.0f;
    public float homingPower = 0.0f;
    public float homingRange = 50.0f;
    public float homingDelay = -1.0f;
    public Color lightningColor = Pal.surge;
    public int lightning;
    public int lightningLength = 5;
    public int lightningLengthRand = 0;
    public float lightningDamage = -1.0f;
    public float lightningCone = 360.0f;
    public float lightningAngle = 0.0f;
    @Nullable
    public BulletType lightningType = null;
    public float weaveScale = 1.0f;
    public float weaveMag = -1.0f;
    public float hitShake = 0.0f;
    public float despawnShake = 0.0f;
    public int puddles;
    public float puddleRange;
    public float puddleAmount = 5.0f;
    public Liquid puddleLiquid = Liquids.water;
    public float lightRadius = 16.0f;
    public float lightOpacity = 0.3f;
    public Color lightColor = Pal.powerLight;

    public BulletType(float speed, float damage) {
        this.speed = speed;
        this.damage = damage;
        this.hitEffect = Fx.hitBulletSmall;
        this.despawnEffect = Fx.hitBulletSmall;
    }

    public BulletType() {
        this(1.0f, 1.0f);
    }

    public float estimateDPS() {
        float sum = this.damage + this.splashDamage * 0.75f;
        if (this.fragBullet != null && this.fragBullet != this) {
            sum += this.fragBullet.estimateDPS() * (float)this.fragBullets / 2.0f;
        }
        return sum;
    }

    public float range() {
        return Math.max(this.speed * this.lifetime * (1.0f - this.drag), this.maxRange);
    }

    public float continuousDamage() {
        return -1.0f;
    }

    public boolean testCollision(Bullet bullet, Building tile) {
        return this.healPercent <= 0.001f || tile.team != bullet.team || tile.healthf() < 1.0f;
    }

    public void hitTile(Bullet b, Building build, float initialHealth, boolean direct) {
        if (this.makeFire && build.team != b.team) {
            Fires.create(build.tile);
        }
        if (this.healPercent > 0.0f && build.team == b.team && !(build.block instanceof ConstructBlock)) {
            Fx.healBlockFull.at(build.x, build.y, (float)build.block.size, Pal.heal);
            build.heal(this.healPercent / 100.0f * build.maxHealth());
        } else if (build.team != b.team && direct) {
            this.hit(b);
        }
    }

    public void hitEntity(Bullet b, Hitboxc other, float initialHealth) {
    }

    public void hit(Bullet b) {
        this.hit(b, b.x, b.y);
    }

    public void hit(Bullet b, float x, float y) {
        int i;
        b.hit = true;
        this.hitEffect.at(x, y, b.rotation(), this.hitColor);
        this.hitSound.at(x, y, this.hitSoundPitch, this.hitSoundVolume);
        Effect.shake(this.hitShake, this.hitShake, b);
        if (this.fragBullet != null) {
            for (i = 0; i < this.fragBullets; ++i) {
                float len = Mathf.random(1.0f, 7.0f);
                float a = b.rotation() + Mathf.range(this.fragCone / 2.0f) + this.fragAngle;
                this.fragBullet.create(b, x + Angles.trnsx(a, len), y + Angles.trnsy(a, len), a, Mathf.random(this.fragVelocityMin, this.fragVelocityMax), Mathf.random(this.fragLifeMin, this.fragLifeMax));
            }
        }
        if (this.puddleLiquid != null && this.puddles > 0) {
            for (i = 0; i < this.puddles; ++i) {
                Tile tile = Vars.world.tileWorld(x + Mathf.range(this.puddleRange), y + Mathf.range(this.puddleRange));
                Puddles.deposit(tile, this.puddleLiquid, this.puddleAmount);
            }
        }
        if (Mathf.chance(this.incendChance)) {
            Damage.createIncend(x, y, this.incendSpread, this.incendAmount);
        }
        if (this.splashDamageRadius > 0.0f && !b.absorbed) {
            Damage.damage(b.team, x, y, this.splashDamageRadius, this.splashDamage * b.damageMultiplier(), this.collidesAir, this.collidesGround);
            if (this.status != StatusEffects.none) {
                Damage.status(b.team, x, y, this.splashDamageRadius, this.status, this.statusDuration, this.collidesAir, this.collidesGround);
            }
            if (this.healPercent > 0.0f) {
                Vars.indexer.eachBlock(b.team, x, y, this.splashDamageRadius, Building::damaged, other -> {
                    Fx.healBlockFull.at(other.x, other.y, (float)other.block.size, Pal.heal);
                    other.heal(this.healPercent / 100.0f * other.maxHealth());
                });
            }
            if (this.makeFire) {
                Vars.indexer.eachBlock(null, x, y, this.splashDamageRadius, other -> other.team != b.team, other -> Fires.create(other.tile));
            }
        }
        for (i = 0; i < this.lightning; ++i) {
            Lightning.create(b, this.lightningColor, this.lightningDamage < 0.0f ? this.damage : this.lightningDamage, b.x, b.y, b.rotation() + Mathf.range(this.lightningCone / 2.0f) + this.lightningAngle, this.lightningLength + Mathf.random(this.lightningLengthRand));
        }
    }

    public void despawned(Bullet b) {
        this.despawnEffect.at(b.x, b.y, b.rotation(), this.hitColor);
        this.hitSound.at(b);
        Effect.shake(this.despawnShake, this.despawnShake, b);
        if (!b.hit && (this.fragBullet != null || this.splashDamageRadius > 0.0f || this.lightning > 0)) {
            this.hit(b);
        }
    }

    public void draw(Bullet b) {
    }

    public void drawLight(Bullet b) {
        Drawf.light(b.team, b, this.lightRadius, this.lightColor, this.lightOpacity);
    }

    public void init(Bullet b) {
        Healthc h;
        Entityc entityc;
        if (this.killShooter && (entityc = b.owner()) instanceof Healthc && (h = (Healthc)entityc) == (Healthc)entityc) {
            h.kill();
        }
        if (this.instantDisappear) {
            b.time = this.lifetime;
        }
    }

    public void update(Bullet b) {
        Teamc target;
        if (this.homingPower > 1.0E-4f && b.time >= this.homingDelay && (target = Units.closestTarget(b.team, b.x, b.y, this.homingRange, e -> e.isGrounded() && this.collidesGround || e.isFlying() && this.collidesAir, t -> this.collidesGround)) != null) {
            b.vel.setAngle(Angles.moveToward(b.rotation(), b.angleTo(target), this.homingPower * Time.delta * 50.0f));
        }
        if (this.weaveMag > 0.0f) {
            b.vel.rotate(Mathf.sin(b.time + (float)Math.PI * this.weaveScale / 2.0f, this.weaveScale, this.weaveMag * (float)(Mathf.randomSeed((long)b.id, 0, 1) == 1 ? -1 : 1)) * Time.delta);
        }
        if (this.trailChance > 0.0f && Mathf.chanceDelta(this.trailChance)) {
            this.trailEffect.at(b.x, b.y, this.trailParam, this.trailColor);
        }
    }

    @Override
    public void init() {
        if (this.pierceCap >= 1) {
            this.pierce = true;
        }
        if (this.lightningType == null) {
            this.lightningType = !this.collidesAir ? Bullets.damageLightningGround : Bullets.damageLightning;
        }
    }

    @Override
    public ContentType getContentType() {
        return ContentType.bullet;
    }

    public Bullet create(Teamc owner, float x, float y, float angle) {
        return this.create(owner, owner.team(), x, y, angle);
    }

    public Bullet create(Entityc owner, Team team, float x, float y, float angle) {
        return this.create(owner, team, x, y, angle, 1.0f);
    }

    public Bullet create(Entityc owner, Team team, float x, float y, float angle, float velocityScl) {
        return this.create(owner, team, x, y, angle, -1.0f, velocityScl, 1.0f, null);
    }

    public Bullet create(Entityc owner, Team team, float x, float y, float angle, float velocityScl, float lifetimeScl) {
        return this.create(owner, team, x, y, angle, -1.0f, velocityScl, lifetimeScl, null);
    }

    public Bullet create(Bullet parent, float x, float y, float angle) {
        return this.create(parent.owner, parent.team, x, y, angle);
    }

    public Bullet create(Bullet parent, float x, float y, float angle, float velocityScl, float lifeScale) {
        return this.create(parent.owner, parent.team, x, y, angle, velocityScl, lifeScale);
    }

    public Bullet create(Bullet parent, float x, float y, float angle, float velocityScl) {
        return this.create(parent.owner(), parent.team, x, y, angle, velocityScl);
    }

    public Bullet create(@Nullable Entityc owner, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data) {
        Velc v;
        Entityc entityc;
        Bullet bullet = Bullet.create();
        bullet.type = this;
        bullet.owner = owner;
        bullet.team = team;
        bullet.time = 0.0f;
        bullet.vel.trns(angle, this.speed * velocityScl);
        if (this.backMove) {
            bullet.set(x - bullet.vel.x * Time.delta, y - bullet.vel.y * Time.delta);
        } else {
            bullet.set(x, y);
        }
        bullet.lifetime = this.lifetime * lifetimeScl;
        bullet.data = data;
        bullet.drag = this.drag;
        bullet.hitSize = this.hitSize;
        bullet.damage = (damage < 0.0f ? this.damage : damage) * bullet.damageMultiplier();
        bullet.add();
        if (this.keepVelocity && (entityc = owner) instanceof Velc && (v = (Velc)entityc) == (Velc)entityc) {
            bullet.vel.add(v.vel().x, v.vel().y);
        }
        return bullet;
    }

    public void createNet(Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl) {
        Call.createBullet(this, team, x, y, angle, damage, velocityScl, lifetimeScl);
    }

    public static void createBullet(BulletType type, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl) {
        if (type == null) {
            return;
        }
        type.create(null, team, x, y, angle, damage, velocityScl, lifetimeScl, null);
    }
}

