/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.graphics.Drawf;

public class ContinuousLaserBulletType
extends BulletType {
    public float length = 220.0f;
    public float shake = 1.0f;
    public float fadeTime = 16.0f;
    public float lightStroke = 40.0f;
    public float spaceMag = 35.0f;
    public Color[] colors = new Color[]{Color.valueOf("ec745855"), Color.valueOf("ec7458aa"), Color.valueOf("ff9c5a"), Color.white};
    public float[] tscales = new float[]{1.0f, 0.7f, 0.5f, 0.2f};
    public float[] strokes = new float[]{2.0f, 1.5f, 1.0f, 0.3f};
    public float[] lenscales = new float[]{1.0f, 1.12f, 1.15f, 1.17f};
    public float width = 9.0f;
    public float oscScl = 0.8f;
    public float oscMag = 1.5f;
    public boolean largeHit = true;

    public ContinuousLaserBulletType(float damage) {
        super(0.001f, damage);
        this.hitEffect = Fx.hitBeam;
        this.despawnEffect = Fx.none;
        this.hitSize = 4.0f;
        this.drawSize = 420.0f;
        this.lifetime = 16.0f;
        this.hitColor = this.colors[2];
        this.incendAmount = 1;
        this.incendSpread = 5.0f;
        this.incendChance = 0.4f;
        this.lightColor = Color.orange;
        this.keepVelocity = false;
        this.collides = false;
        this.pierce = true;
        this.hittable = false;
        this.absorbable = false;
    }

    protected ContinuousLaserBulletType() {
        this(0.0f);
    }

    @Override
    public float continuousDamage() {
        return this.damage / 5.0f * 60.0f;
    }

    @Override
    public float estimateDPS() {
        return this.damage * 100.0f / 5.0f * 3.0f;
    }

    @Override
    public float range() {
        return Math.max(this.length, this.maxRange);
    }

    @Override
    public void init() {
        super.init();
        this.drawSize = Math.max(this.drawSize, this.length * 2.0f);
    }

    @Override
    public void update(Bullet b) {
        if (b.timer(1, 5.0f)) {
            Damage.collideLine(b, b.team, this.hitEffect, b.x, b.y, b.rotation(), this.length, this.largeHit);
        }
        if (this.shake > 0.0f) {
            Effect.shake(this.shake, this.shake, b);
        }
    }

    @Override
    public void draw(Bullet b) {
        float realLength = Damage.findLaserLength(b, this.length);
        float fout = Mathf.clamp(b.time > b.lifetime - this.fadeTime ? 1.0f - (b.time - (this.lifetime - this.fadeTime)) / this.fadeTime : 1.0f);
        float baseLen = realLength * fout;
        Lines.lineAngle(b.x, b.y, b.rotation(), baseLen);
        for (int s = 0; s < this.colors.length; ++s) {
            Draw.color(Tmp.c1.set(this.colors[s]).mul(1.0f + Mathf.absin(Time.time, 1.0f, 0.1f)));
            for (int i = 0; i < this.tscales.length; ++i) {
                Tmp.v1.trns(b.rotation() + 180.0f, (this.lenscales[i] - 1.0f) * this.spaceMag);
                Lines.stroke((this.width + Mathf.absin(Time.time, this.oscScl, this.oscMag)) * fout * this.strokes[s] * this.tscales[i]);
                Lines.lineAngle(b.x + Tmp.v1.x, b.y + Tmp.v1.y, b.rotation(), baseLen * this.lenscales[i], false);
            }
        }
        Tmp.v1.trns(b.rotation(), baseLen * 1.1f);
        Drawf.light(b.team, b.x, b.y, b.x + Tmp.v1.x, b.y + Tmp.v1.y, this.lightStroke, this.lightColor, 0.7f);
        Draw.reset();
    }

    @Override
    public void drawLight(Bullet b) {
    }
}

