/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.util.Time;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.entities.Units;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.gen.Bullet;

public class FlakBulletType
extends BasicBulletType {
    public float explodeRange = 30.0f;

    public FlakBulletType(float speed, float damage) {
        super(speed, damage, "shell");
        this.splashDamage = 15.0f;
        this.splashDamageRadius = 34.0f;
        this.hitEffect = Fx.flakExplosionBig;
        this.width = 8.0f;
        this.height = 10.0f;
        this.collidesGround = false;
    }

    public FlakBulletType() {
        this(1.0f, 1.0f);
    }

    @Override
    public void update(Bullet b) {
        super.update(b);
        if (b.data() instanceof Integer) {
            return;
        }
        if (b.timer(2, 6.0f)) {
            Units.nearbyEnemies(b.team, Tmp.r1.setSize(this.explodeRange * 2.0f).setCenter(b.x, b.y), unit -> {
                if (b.data() instanceof Float || !unit.checkTarget(this.collidesAir, this.collidesGround)) {
                    return;
                }
                if (unit.dst(b) < this.explodeRange) {
                    b.data(0);
                    Time.run(5.0f, () -> {
                        if (b.data() instanceof Integer) {
                            b.time(b.lifetime());
                        }
                    });
                }
            });
        }
    }
}

