/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.math.Angles;
import arc.math.Mathf;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.graphics.Pal;
import mindustry.world.blocks.distribution.MassDriver;

public class MassDriverBolt
extends BulletType {
    public MassDriverBolt() {
        super(1.0f, 50.0f);
        this.collidesTiles = false;
        this.lifetime = 1.0f;
        this.despawnEffect = Fx.smeltsmoke;
        this.hitEffect = Fx.hitBulletBig;
    }

    @Override
    public void draw(Bullet b) {
        float w = 11.0f;
        float h = 13.0f;
        Draw.color(Pal.bulletYellowBack);
        Draw.rect("shell-back", b.x, b.y, w, h, b.rotation() + 90.0f);
        Draw.color(Pal.bulletYellow);
        Draw.rect("shell", b.x, b.y, w, h, b.rotation() + 90.0f);
        Draw.reset();
    }

    @Override
    public void update(Bullet b) {
        float baseAngle;
        float angleTo;
        MassDriver.DriverBulletData data;
        Object object = b.data();
        if (!(object instanceof MassDriver.DriverBulletData) || (data = (MassDriver.DriverBulletData)object) != (MassDriver.DriverBulletData)object) {
            this.hit(b);
            return;
        }
        float hitDst = 7.0f;
        if (data.to.dead()) {
            return;
        }
        float baseDst = data.from.dst(data.to);
        float dst1 = b.dst(data.from);
        float dst2 = b.dst(data.to);
        boolean intersect = false;
        if (dst1 > baseDst && Angles.near(angleTo = b.angleTo(data.to), baseAngle = data.to.angleTo(data.from), 2.0f)) {
            intersect = true;
            b.set(data.to.x + Angles.trnsx(baseAngle, hitDst), data.to.y + Angles.trnsy(baseAngle, hitDst));
        }
        if (Math.abs(dst1 + dst2 - baseDst) < 4.0f && dst2 <= hitDst) {
            intersect = true;
        }
        if (intersect) {
            data.to.handlePayload(b, data);
        }
    }

    @Override
    public void despawned(Bullet b) {
        MassDriver.DriverBulletData data;
        super.despawned(b);
        Object object = b.data();
        if (!(object instanceof MassDriver.DriverBulletData) || (data = (MassDriver.DriverBulletData)object) != (MassDriver.DriverBulletData)object) {
            return;
        }
        for (int i = 0; i < data.items.length; ++i) {
            int amountDropped = Mathf.random(0, data.items[i]);
            if (amountDropped <= 0) continue;
            float angle = b.rotation() + Mathf.range(100.0f);
            Fx.dropItem.at(b.x, b.y, angle, Color.white, Vars.content.item(i));
        }
    }

    @Override
    public void hit(Bullet b, float hitx, float hity) {
        super.hit(b, hitx, hity);
        this.despawned(b);
    }
}

