/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.math.geom.Vec2;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Hitboxc;
import mindustry.gen.Posc;

public class RailBulletType
extends BulletType {
    public Effect pierceEffect = Fx.hitBulletSmall;
    public Effect updateEffect = Fx.none;
    public float pierceDamageFactor = 1.0f;
    public float length = 100.0f;
    public float updateEffectSeg = 20.0f;

    public RailBulletType() {
        this.pierceBuilding = true;
        this.pierce = true;
        this.reflectable = false;
        this.hitEffect = Fx.none;
        this.despawnEffect = Fx.none;
        this.collides = false;
        this.lifetime = 1.0f;
        this.speed = 0.01f;
    }

    @Override
    public float range() {
        return this.length;
    }

    void handle(Bullet b, Posc pos, float initialHealth) {
        float sub = Math.max(initialHealth * this.pierceDamageFactor, 0.0f);
        if (b.damage <= 0.0f) {
            b.fdata = Math.min(b.fdata, b.dst(pos));
            return;
        }
        if (b.damage > 0.0f) {
            this.pierceEffect.at(pos.getX(), pos.getY(), b.rotation());
            this.hitEffect.at(pos.getX(), pos.getY());
        }
        b.damage -= Math.min(b.damage, sub);
    }

    @Override
    public void init(Bullet b) {
        super.init(b);
        b.fdata = this.length;
        Damage.collideLine(b, b.team, b.type.hitEffect, b.x, b.y, b.rotation(), this.length, false, false);
        float resultLen = b.fdata;
        Vec2 nor = Tmp.v1.set(b.vel).nor();
        for (float i = 0.0f; i <= resultLen; i += this.updateEffectSeg) {
            this.updateEffect.at(b.x + nor.x * i, b.y + nor.y * i, b.rotation());
        }
    }

    @Override
    public boolean testCollision(Bullet bullet, Building tile) {
        return bullet.team != tile.team;
    }

    @Override
    public void hitEntity(Bullet b, Hitboxc entity, float initialHealth) {
        this.handle(b, entity, initialHealth);
    }

    @Override
    public void hitTile(Bullet b, Building build, float initialHealth, boolean direct) {
        this.handle(b, build, initialHealth);
    }
}

