/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Damage;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Healthc;
import mindustry.gen.Hitboxc;
import mindustry.graphics.Drawf;

public class SapBulletType
extends BulletType {
    public float length = 100.0f;
    public float sapStrength = 0.5f;
    public Color color = Color.white.cpy();
    public float width = 0.4f;

    public SapBulletType() {
        this.speed = 1.0E-4f;
        this.despawnEffect = Fx.none;
        this.pierce = true;
        this.collides = false;
        this.hitSize = 0.0f;
        this.hittable = false;
        this.hitEffect = Fx.hitLiquid;
        this.status = StatusEffects.sapped;
        this.statusDuration = 180.0f;
    }

    @Override
    public void draw(Bullet b) {
        Position data;
        Object object = b.data;
        if (object instanceof Position && (data = (Position)object) == (Position)object) {
            Tmp.v1.set(data).lerp(b, b.fin());
            Draw.color(this.color);
            Drawf.laser(b.team, Core.atlas.find("laser"), Core.atlas.find("laser-end"), b.x, b.y, Tmp.v1.x, Tmp.v1.y, this.width * b.fout());
            Draw.reset();
            Drawf.light(b.team, b.x, b.y, Tmp.v1.x, Tmp.v1.y, 15.0f * b.fout(), this.lightColor, 0.6f);
        }
    }

    @Override
    public void drawLight(Bullet b) {
    }

    @Override
    public float range() {
        return Math.max(this.length, this.maxRange);
    }

    @Override
    public void init(Bullet b) {
        Hitboxc hit;
        Entityc entityc;
        super.init(b);
        Healthc target = Damage.linecast(b, b.x, b.y, b.rotation(), this.length);
        b.data = target;
        if (target != null) {
            Entityc h;
            float result = Math.max(Math.min(target.health(), this.damage), 0.0f);
            entityc = b.owner;
            if (entityc instanceof Healthc && (h = entityc) == entityc) {
                h.heal(result * this.sapStrength);
            }
        }
        if ((entityc = target) instanceof Hitboxc && (hit = (Hitboxc)entityc) == (Hitboxc)entityc) {
            hit.collision(b, hit.x(), hit.y());
            b.collision(hit, hit.x(), hit.y());
        } else {
            Building tile;
            entityc = target;
            if (entityc instanceof Building && (tile = (Building)entityc) == (Building)entityc) {
                if (tile.collide(b)) {
                    tile.collision(b);
                    this.hit(b, tile.x, tile.y);
                }
            } else {
                b.data = new Vec2().trns(b.rotation(), this.length).add(b.x, b.y);
            }
        }
    }
}

