/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.math.Mathf;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;

public class ShrapnelBulletType
extends BulletType {
    public float length = 100.0f;
    public float width = 20.0f;
    public Color fromColor = Color.white;
    public Color toColor = Pal.lancerLaser;
    public boolean hitLarge = false;
    public int serrations = 7;
    public float serrationLenScl = 10.0f;
    public float serrationWidth = 4.0f;
    public float serrationSpacing = 8.0f;
    public float serrationSpaceOffset = 80.0f;
    public float serrationFadeOffset = 0.5f;

    public ShrapnelBulletType() {
        this.speed = 0.01f;
        this.hitEffect = Fx.hitLancer;
        this.shootEffect = this.smokeEffect = Fx.lightningShoot;
        this.lifetime = 10.0f;
        this.despawnEffect = Fx.none;
        this.keepVelocity = false;
        this.collides = false;
        this.pierce = true;
        this.hittable = false;
        this.absorbable = false;
    }

    @Override
    public void init(Bullet b) {
        super.init(b);
        Damage.collideLaser(b, this.length, this.hitLarge);
    }

    @Override
    public void init() {
        super.init();
        this.drawSize = Math.max(this.drawSize, this.length * 2.0f);
    }

    @Override
    public float range() {
        return Math.max(this.length, this.maxRange);
    }

    @Override
    public void draw(Bullet b) {
        float realLength = b.fdata;
        Draw.color(this.fromColor, this.toColor, b.fin());
        for (int i = 0; i < (int)((float)this.serrations * realLength / this.length); ++i) {
            Tmp.v1.trns(b.rotation(), (float)i * this.serrationSpacing);
            float sl = Mathf.clamp(b.fout() - this.serrationFadeOffset) * (this.serrationSpaceOffset - (float)i * this.serrationLenScl);
            Drawf.tri(b.x + Tmp.v1.x, b.y + Tmp.v1.y, this.serrationWidth, sl, b.rotation() + 90.0f);
            Drawf.tri(b.x + Tmp.v1.x, b.y + Tmp.v1.y, this.serrationWidth, sl, b.rotation() - 90.0f);
        }
        Drawf.tri(b.x, b.y, this.width * b.fout(), realLength + 50.0f, b.rotation());
        Drawf.tri(b.x, b.y, this.width * b.fout(), 10.0f, b.rotation() + 180.0f);
        Draw.reset();
    }
}

