/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.graphics.g2d.TextureRegion;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Unitc;
import mindustry.ui.Cicon;

abstract class BlockUnitComp
implements Unitc {
    Team team;
    transient Building tile;

    BlockUnitComp() {
    }

    public void tile(Building tile) {
        this.tile = tile;
        this.maxHealth(tile.block.health);
        this.health(tile.health());
        this.hitSize((float)(tile.block.size * 8) * 0.7f);
        this.set(tile);
    }

    @Override
    public void update() {
        if (this.tile != null) {
            this.team = this.tile.team;
        }
    }

    @Override
    public TextureRegion icon() {
        return this.tile.block.icon(Cicon.full);
    }

    @Override
    public void killed() {
        this.tile.kill();
    }

    @Override
    public void damage(float v, boolean b) {
        this.tile.damage(v, b);
    }

    @Override
    public boolean dead() {
        return this.tile == null || this.tile.dead();
    }

    @Override
    public boolean isValid() {
        return this.tile != null && this.tile.isValid();
    }

    @Override
    public void team(Team team) {
        if (this.tile != null && this.team != team) {
            this.team = team;
            if (this.tile.team != team) {
                this.tile.team(team);
            }
        }
    }
}

