/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.math.Mathf;
import arc.math.geom.Vec2;
import mindustry.Vars;
import mindustry.gen.Flyingc;
import mindustry.gen.Healthc;
import mindustry.gen.Posc;
import mindustry.gen.Velc;

abstract class BoundedComp
implements Velc,
Posc,
Healthc,
Flyingc {
    static final float warpDst = 180.0f;
    float x;
    float y;
    Vec2 vel;

    BoundedComp() {
    }

    @Override
    public void update() {
        if (!Vars.net.client() || this.isLocal()) {
            if (this.x < 0.0f) {
                this.vel.x += -this.x / 180.0f;
            }
            if (this.y < 0.0f) {
                this.vel.y += -this.y / 180.0f;
            }
            if (this.x > (float)Vars.world.unitWidth()) {
                this.vel.x -= (this.x - (float)Vars.world.unitWidth()) / 180.0f;
            }
            if (this.y > (float)Vars.world.unitHeight()) {
                this.vel.y -= (this.y - (float)Vars.world.unitHeight()) / 180.0f;
            }
        }
        if (this.isGrounded()) {
            this.x = Mathf.clamp(this.x, 0.0f, (float)(Vars.world.width() * 8 - 8));
            this.y = Mathf.clamp(this.y, 0.0f, (float)(Vars.world.height() * 8 - 8));
        }
        if (this.x < -500.0f || this.y < -500.0f || this.x >= (float)(Vars.world.width() * 8) + 500.0f || this.y >= (float)(Vars.world.height() * 8) + 500.0f) {
            this.kill();
        }
    }
}

