/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.Queue;
import arc.util.Nullable;
import arc.util.Structs;
import arc.util.Time;
import java.util.Arrays;
import java.util.Iterator;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Posc;
import mindustry.gen.Rotc;
import mindustry.gen.Statusc;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustry.world.Build;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.storage.CoreBlock;

abstract class BuilderComp
implements Posc,
Statusc,
Teamc,
Rotc {
    static final Vec2[] vecs = new Vec2[]{new Vec2(), new Vec2(), new Vec2(), new Vec2()};
    float x;
    float y;
    float rotation;
    float buildSpeedMultiplier;
    UnitType type;
    Team team;
    Queue<BuildPlan> plans = new Queue(1);
    boolean updateBuilding = true;
    private transient BuildPlan lastActive;
    private transient int lastSize;
    private transient float buildAlpha = 0.0f;

    BuilderComp() {
    }

    public boolean canBuild() {
        return this.type.buildSpeed > 0.0f && this.buildSpeedMultiplier > 0.0f;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void update() {
        ConstructBlock.ConstructBuild entity;
        Building building;
        Tile tile;
        BuildPlan current;
        Building core;
        boolean infinite;
        block20: {
            ConstructBlock.ConstructBuild cb;
            block21: {
                if (!Vars.headless) {
                    if (this.lastActive != null && this.buildAlpha <= 0.01f) {
                        this.lastActive = null;
                    }
                    this.buildAlpha = Mathf.lerpDelta(this.buildAlpha, this.activelyBuilding() ? 1.0f : 0.0f, 0.15f);
                }
                if (!this.updateBuilding || !this.canBuild()) {
                    return;
                }
                float finalPlaceDst = Vars.state.rules.infiniteResources ? Float.MAX_VALUE : 220.0f;
                infinite = Vars.state.rules.infiniteResources || this.team().rules().infiniteResources;
                Iterator<BuildPlan> it = this.plans.iterator();
                while (it.hasNext()) {
                    BuildPlan req = it.next();
                    Tile tile2 = Vars.world.tile(req.x, req.y);
                    if (tile2 != null && (!req.breaking || tile2.block() != Blocks.air) && (req.breaking || (tile2.build == null || tile2.build.rotation != req.rotation) && req.block.rotate || tile2.block() != req.block)) continue;
                    it.remove();
                }
                core = this.core();
                if (this.buildPlan() == null) {
                    return;
                }
                if (this.plans.size > 1) {
                    BuildPlan req;
                    for (int total = 0; (!this.within((req = this.buildPlan()).tile(), finalPlaceDst) || this.shouldSkip(req, core)) && total < this.plans.size; ++total) {
                        this.plans.removeFirst();
                        this.plans.addLast(req);
                    }
                }
                current = this.buildPlan();
                tile = current.tile();
                this.lastActive = current;
                this.buildAlpha = 1.0f;
                if (current.breaking) {
                    this.lastSize = tile.block().size;
                }
                if (!this.within(tile, finalPlaceDst)) {
                    return;
                }
                Building building2 = tile.build;
                if (building2 instanceof ConstructBlock.ConstructBuild && (cb = (ConstructBlock.ConstructBuild)building2) == (ConstructBlock.ConstructBuild)building2) break block21;
                if (!current.initialized && !current.breaking && Build.validPlace(current.block, this.team, current.x, current.y, current.rotation)) {
                    boolean hasAll;
                    boolean bl = hasAll = infinite || current.isRotation(this.team) || !Structs.contains(current.block.requirements, i -> core != null && !core.items.has(i.item));
                    if (hasAll) {
                        Call.beginPlace((Unit)this.self(), current.block, this.team, current.x, current.y, current.rotation);
                        break block20;
                    } else {
                        current.stuck = true;
                    }
                    break block20;
                } else if (!current.initialized && current.breaking && Build.validBreak(this.team, current.x, current.y)) {
                    Call.beginBreak((Unit)this.self(), this.team, current.x, current.y);
                    break block20;
                } else {
                    this.plans.removeFirst();
                    return;
                }
            }
            if (tile.team() != this.team && tile.team() != Team.derelict || !current.breaking && (cb.cblock != current.block || cb.tile != current.tile())) {
                this.plans.removeFirst();
                return;
            }
        }
        if (tile.build instanceof ConstructBlock.ConstructBuild && !current.initialized) {
            Core.app.post(() -> Events.fire(new EventType.BuildSelectEvent(tile, this.team, (Unit)this.self(), current.breaking)));
            current.initialized = true;
        }
        if (core == null && !infinite || !((building = tile.build) instanceof ConstructBlock.ConstructBuild) || (entity = (ConstructBlock.ConstructBuild)building) != (ConstructBlock.ConstructBuild)building) {
            return;
        }
        if (current.breaking) {
            entity.deconstruct((Unit)this.self(), core, 1.0f / entity.buildCost * Time.delta * this.type.buildSpeed * this.buildSpeedMultiplier * Vars.state.rules.buildSpeedMultiplier);
        } else {
            entity.construct((Unit)this.self(), core, 1.0f / entity.buildCost * Time.delta * this.type.buildSpeed * this.buildSpeedMultiplier * Vars.state.rules.buildSpeedMultiplier, current.config);
        }
        current.stuck = Mathf.equal(current.progress, entity.progress);
        current.progress = entity.progress;
    }

    void drawBuildPlans() {
        Boolf<BuildPlan> skip = plan -> plan.progress > 0.01f || this.buildPlan() == plan && plan.initialized && (this.within(plan.x * 8, plan.y * 8, 220.0f) || Vars.state.isEditor());
        for (int i = 0; i < 2; ++i) {
            for (BuildPlan plan2 : this.plans) {
                if (skip.get(plan2)) continue;
                if (i == 0) {
                    this.drawPlan(plan2, 1.0f);
                    continue;
                }
                this.drawPlanTop(plan2, 1.0f);
            }
        }
        Draw.reset();
    }

    void drawPlan(BuildPlan request, float alpha) {
        request.animScale = 1.0f;
        if (request.breaking) {
            Vars.control.input.drawBreaking(request);
        } else {
            request.block.drawPlan(request, Vars.control.input.allRequests(), Build.validPlace(request.block, this.team, request.x, request.y, request.rotation) || Vars.control.input.requestMatches(request), alpha);
        }
    }

    void drawPlanTop(BuildPlan request, float alpha) {
        if (!request.breaking) {
            Draw.reset();
            Draw.mixcol(Color.white, 0.24f + Mathf.absin(Time.globalTime, 6.0f, 0.28f));
            Draw.alpha(alpha);
            request.block.drawRequestConfigTop(request, this.plans);
        }
    }

    boolean shouldSkip(BuildPlan request, @Nullable Building core) {
        if (Vars.state.rules.infiniteResources || this.team.rules().infiniteResources || request.breaking || core == null || request.isRotation(this.team)) {
            return false;
        }
        return request.stuck && !core.items.has(request.block.requirements) || Structs.contains(request.block.requirements, i -> !core.items.has(i.item) && Mathf.round((float)i.amount * Vars.state.rules.buildCostMultiplier) > 0) && !request.initialized;
    }

    void removeBuild(int x, int y, boolean breaking) {
        int idx = this.plans.indexOf(req -> req.breaking == breaking && req.x == x && req.y == y);
        if (idx != -1) {
            this.plans.removeIndex(idx);
        }
    }

    boolean isBuilding() {
        return this.plans.size != 0;
    }

    void clearBuilding() {
        this.plans.clear();
    }

    void addBuild(BuildPlan place) {
        this.addBuild(place, true);
    }

    void addBuild(BuildPlan place, boolean tail) {
        ConstructBlock.ConstructBuild cons;
        Building building;
        Tile tile;
        if (!this.canBuild()) {
            return;
        }
        BuildPlan replace = null;
        for (BuildPlan request : this.plans) {
            if (request.x != place.x || request.y != place.y) continue;
            replace = request;
            break;
        }
        if (replace != null) {
            this.plans.remove(replace);
        }
        if ((tile = Vars.world.tile(place.x, place.y)) != null && (building = tile.build) instanceof ConstructBlock.ConstructBuild && (cons = (ConstructBlock.ConstructBuild)building) == (ConstructBlock.ConstructBuild)building) {
            place.progress = cons.progress;
        }
        if (tail) {
            this.plans.addLast(place);
        } else {
            this.plans.addFirst(place);
        }
    }

    boolean activelyBuilding() {
        if (this.isBuilding() && !Vars.state.isEditor() && !this.within(this.buildPlan(), Vars.state.rules.infiniteResources ? Float.MAX_VALUE : 220.0f)) {
            return false;
        }
        return this.isBuilding() && this.updateBuilding;
    }

    @Nullable
    BuildPlan buildPlan() {
        return this.plans.size == 0 ? null : this.plans.first();
    }

    @Override
    public void draw() {
        boolean active = this.activelyBuilding();
        if (!active && this.lastActive == null) {
            return;
        }
        Draw.z(115.0f);
        BuildPlan plan = active ? this.buildPlan() : this.lastActive;
        Tile tile = Vars.world.tile(plan.x, plan.y);
        CoreBlock.CoreBuild core = this.team.core();
        if (tile == null || !this.within(plan, Vars.state.rules.infiniteResources ? Float.MAX_VALUE : 220.0f)) {
            return;
        }
        if (core != null && active && !this.isLocal() && !(tile.block() instanceof ConstructBlock)) {
            Draw.z(84.0f);
            this.drawPlan(plan, 0.5f);
            this.drawPlanTop(plan, 0.5f);
            Draw.z(115.0f);
        }
        int size = plan.breaking ? (active ? tile.block().size : this.lastSize) : plan.block.size;
        float tx = plan.drawx();
        float ty = plan.drawy();
        Lines.stroke(1.0f, plan.breaking ? Pal.remove : Pal.accent);
        float focusLen = this.type.buildBeamOffset + Mathf.absin(Time.time, 3.0f, 0.6f);
        float px = this.x + Angles.trnsx(this.rotation, focusLen);
        float py = this.y + Angles.trnsy(this.rotation, focusLen);
        float sz = (float)(8 * size) / 2.0f;
        float ang = this.angleTo(tx, ty);
        vecs[0].set(tx - sz, ty - sz);
        vecs[1].set(tx + sz, ty - sz);
        vecs[2].set(tx - sz, ty + sz);
        vecs[3].set(tx + sz, ty + sz);
        Arrays.sort(vecs, Structs.comparingFloat(vec -> -Angles.angleDist(this.angleTo((Position)vec), ang)));
        Vec2 close = (Vec2)Geometry.findClosest((float)this.x, (float)this.y, (Position[])vecs);
        float x1 = BuilderComp.vecs[0].x;
        float y1 = BuilderComp.vecs[0].y;
        float x2 = close.x;
        float y2 = close.y;
        float x3 = BuilderComp.vecs[1].x;
        float y3 = BuilderComp.vecs[1].y;
        Draw.z(122.0f);
        Draw.alpha(this.buildAlpha);
        if (!active && !(tile.build instanceof ConstructBlock.ConstructBuild)) {
            Fill.square(plan.drawx(), plan.drawy(), (float)(size * 8) / 2.0f);
        }
        if (Vars.renderer.animateShields) {
            if (close != vecs[0] && close != vecs[1]) {
                Fill.tri(px, py, x1, y1, x2, y2);
                Fill.tri(px, py, x3, y3, x2, y2);
            } else {
                Fill.tri(px, py, x1, y1, x3, y3);
            }
        } else {
            Lines.line(px, py, x1, y1);
            Lines.line(px, py, x3, y3);
        }
        Fill.square(px, py, 1.8f + Mathf.absin(Time.time, 2.2f, 1.1f), this.rotation + 45.0f);
        Draw.reset();
        Draw.z(115.0f);
    }
}

