/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.Events;
import arc.func.Cons;
import arc.graphics.g2d.Draw;
import arc.math.Mathf;
import arc.math.geom.QuadTree;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.core.World;
import mindustry.entities.bullet.BulletType;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Bulletc;
import mindustry.gen.Damagec;
import mindustry.gen.Drawc;
import mindustry.gen.Entityc;
import mindustry.gen.Flyingc;
import mindustry.gen.Healthc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Ownerc;
import mindustry.gen.Posc;
import mindustry.gen.Shielderc;
import mindustry.gen.Teamc;
import mindustry.gen.Timedc;
import mindustry.gen.Timerc;
import mindustry.gen.Unit;
import mindustry.gen.Velc;
import mindustry.world.blocks.defense.Wall;

abstract class BulletComp
implements Timedc,
Damagec,
Hitboxc,
Teamc,
Posc,
Drawc,
Shielderc,
Ownerc,
Velc,
Bulletc,
Timerc {
    Team team;
    Entityc owner;
    float x;
    float y;
    float damage;
    IntSeq collided = new IntSeq(6);
    Object data;
    BulletType type;
    float fdata;
    transient boolean absorbed;
    transient boolean hit;

    BulletComp() {
    }

    @Override
    public void getCollisions(Cons<QuadTree> consumer) {
        Seq<Teams.TeamData> data = Vars.state.teams.present;
        for (int i = 0; i < data.size; ++i) {
            if (((Teams.TeamData[])data.items)[i].team == this.team) continue;
            consumer.get(((Teams.TeamData[])data.items)[i].tree());
        }
    }

    @Override
    public void drawBullets() {
        this.type.draw((Bullet)this.self());
    }

    @Override
    public void add() {
        this.type.init((Bullet)this.self());
    }

    @Override
    public void remove() {
        this.type.despawned((Bullet)this.self());
        this.collided.clear();
    }

    @Override
    public float damageMultiplier() {
        if (this.owner instanceof Unit) {
            return ((Unit)this.owner).damageMultiplier() * Vars.state.rules.unitDamageMultiplier;
        }
        if (this.owner instanceof Building) {
            return Vars.state.rules.blockDamageMultiplier;
        }
        return 1.0f;
    }

    @Override
    public void absorb() {
        this.absorbed = true;
        this.remove();
    }

    @Override
    public float clipSize() {
        return this.type.drawSize;
    }

    @Override
    public boolean collides(Hitboxc other) {
        return !(!this.type.collides || !(other instanceof Teamc) || ((Teamc)((Object)other)).team() == this.team || other instanceof Flyingc && !((Flyingc)other).checkTarget(this.type.collidesAir, this.type.collidesGround) || this.type.pierce && this.collided.contains(other.id()));
    }

    @Override
    public void collision(Hitboxc other, float x, float y) {
        Unit unit;
        Healthc h;
        this.type.hit((Bullet)this.self(), x, y);
        float health = 0.0f;
        Hitboxc hitboxc = other;
        if (hitboxc instanceof Healthc && (h = (Healthc)((Object)hitboxc)) == (Healthc)((Object)hitboxc)) {
            health = h.health();
            h.damage(this.damage);
        }
        if ((hitboxc = other) instanceof Unit && (unit = (Unit)hitboxc) == (Unit)hitboxc) {
            unit.impulse(Tmp.v3.set(unit).sub(this.x, this.y).nor().scl(this.type.knockback * 80.0f));
            unit.apply(this.type.status, this.type.statusDuration);
        }
        if (!this.type.pierce) {
            this.remove();
        } else {
            this.collided.add(other.id());
        }
        this.type.hitEntity((Bullet)this.self(), other, health);
        if (this.owner instanceof Wall.WallBuild && Vars.player != null && this.team == Vars.player.team() && (hitboxc = other) instanceof Unit && (unit = (Unit)hitboxc) == (Unit)hitboxc && unit.dead) {
            Events.fire(EventType.Trigger.phaseDeflectHit);
        }
    }

    @Override
    public void update() {
        this.type.update((Bullet)this.self());
        if (this.type.collidesTiles && this.type.collides && this.type.collidesGround) {
            Vars.world.raycastEach(World.toTile(this.lastX()), World.toTile(this.lastY()), this.tileX(), this.tileY(), (x, y) -> {
                Building tile = Vars.world.build(x, y);
                if (tile == null || !this.isAdded()) {
                    return false;
                }
                if (!(!tile.collide((Bullet)this.self()) || !this.type.testCollision((Bullet)this.self(), tile) || tile.dead() || !this.type.collidesTeam && tile.team == this.team || this.type.pierceBuilding && this.collided.contains(tile.id))) {
                    boolean remove = false;
                    float health = tile.health;
                    if (tile.team != this.team) {
                        remove = tile.collision((Bullet)this.self());
                    }
                    if (remove || this.type.collidesTeam) {
                        if (!this.type.pierceBuilding) {
                            this.remove();
                        } else {
                            this.collided.add(tile.id);
                        }
                    }
                    this.type.hitTile((Bullet)this.self(), tile, health, true);
                    return !this.type.pierceBuilding;
                }
                return false;
            });
        }
        if (this.type.pierceCap != -1 && this.collided.size >= this.type.pierceCap) {
            this.remove();
        }
    }

    @Override
    public void draw() {
        Draw.z(100.0f);
        this.type.draw((Bullet)this.self());
        this.type.drawLight((Bullet)this.self());
    }

    @Override
    public void rotation(float angle) {
        this.vel().setAngle(angle);
    }

    @Override
    public float rotation() {
        float angle = Mathf.atan2(this.vel().x, this.vel().y) * 57.295776f;
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }
}

