/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.func.Boolf;
import arc.math.geom.Vec3;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.ai.formations.DistanceAssignmentStrategy;
import mindustry.ai.formations.Formation;
import mindustry.ai.formations.FormationMember;
import mindustry.ai.formations.FormationPattern;
import mindustry.ai.types.FormationAI;
import mindustry.entities.Units;
import mindustry.entities.units.UnitController;
import mindustry.game.Team;
import mindustry.gen.Entityc;
import mindustry.gen.Posc;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustry.type.UnitType;

abstract class CommanderComp
implements Entityc,
Posc {
    private static final Seq<FormationMember> members = new Seq();
    private static final Seq<Unit> units = new Seq();
    float x;
    float y;
    float rotation;
    float hitSize;
    Team team;
    UnitType type;
    @Nullable
    transient Formation formation;
    transient Seq<Unit> controlling = new Seq(10);
    transient float minFormationSpeed;

    CommanderComp() {
    }

    @Override
    public void update() {
        if (this.controlling.isEmpty() && !Vars.net.client()) {
            this.formation = null;
        }
        if (this.formation != null) {
            this.formation.anchor.set(this.x, this.y, 0.0f);
            this.formation.updateSlots();
            this.controlling.removeAll(u -> {
                FormationAI ai;
                UnitController ai$temp;
                return u.dead || !((ai$temp = u.controller()) instanceof FormationAI) || (ai = (FormationAI)ai$temp) != (FormationAI)ai$temp || ai.leader != this.self();
            });
        }
    }

    @Override
    public void remove() {
        this.clearCommand();
    }

    public void killed() {
        this.clearCommand();
    }

    public void controller(UnitController next) {
        this.clearCommand();
    }

    void commandNearby(FormationPattern pattern) {
        this.commandNearby(pattern, u -> true);
    }

    void commandNearby(FormationPattern pattern, Boolf<Unit> include) {
        Formation formation = new Formation(new Vec3(this.x, this.y, this.rotation), pattern);
        formation.slotAssignmentStrategy = new DistanceAssignmentStrategy(pattern);
        units.clear();
        Units.nearby(this.team, this.x, this.y, 150.0f, u -> {
            if (u.isAI() && include.get((Unit)u) && u != this.self() && u.type.flying == this.type.flying && u.hitSize <= this.hitSize * 1.1f) {
                units.add((Unit)u);
            }
        });
        if (units.isEmpty()) {
            return;
        }
        units.sort(Structs.comps(Structs.comparingFloat(u -> -u.hitSize), Structs.comparingFloat(u -> u.dst2(this))));
        units.truncate(this.type.commandLimit);
        this.command(formation, units);
    }

    void command(Formation formation, Seq<Unit> units) {
        this.clearCommand();
        units.shuffle();
        float spacing = this.hitSize * 0.8f;
        this.minFormationSpeed = this.type.speed;
        this.controlling.addAll(units);
        for (Unit unit : units) {
            FormationAI ai = new FormationAI((Unit)this.self(), formation);
            unit.controller(ai);
            spacing = Math.max(spacing, ai.formationSize());
            this.minFormationSpeed = Math.min(this.minFormationSpeed, unit.type.speed);
        }
        this.formation = formation;
        formation.pattern.spacing = spacing;
        members.clear();
        for (Unitc unitc : units) {
            members.add((FormationAI)unitc.controller());
        }
        formation.addMembers(members);
    }

    boolean isCommanding() {
        return this.formation != null;
    }

    void clearCommand() {
        for (Unit unit : this.controlling) {
            if (!unit.controller().isBeingControlled((Unit)this.self())) continue;
            unit.controller(unit.type.createController());
        }
        this.controlling.clear();
        this.formation = null;
    }
}

