/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.func.Cons;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.EntityGroup;
import mindustry.gen.Entityc;
import mindustry.gen.Unitc;

abstract class EntityComp {
    private transient boolean added;
    transient int id = EntityGroup.nextId();

    EntityComp() {
    }

    boolean isAdded() {
        return this.added;
    }

    void update() {
    }

    void remove() {
        this.added = false;
    }

    void add() {
        this.added = true;
    }

    boolean isLocal() {
        return this == Vars.player || this instanceof Unitc && ((Unitc)((Object)this)).controller() == Vars.player;
    }

    boolean isRemote() {
        return this instanceof Unitc && ((Unitc)((Object)this)).isPlayer() && !this.isLocal();
    }

    boolean isNull() {
        return false;
    }

    <T extends Entityc> T self() {
        return (T)((Entityc)((Object)this));
    }

    <T> T as() {
        return (T)this;
    }

    <T> T with(Cons<T> cons) {
        cons.get(this);
        return (T)this;
    }

    abstract int classId();

    abstract boolean serialize();

    void read(Reads read) {
        this.afterRead();
    }

    void write(Writes write) {
    }

    void afterRead() {
    }
}

