/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Bullets;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Damage;
import mindustry.entities.Fires;
import mindustry.entities.Puddles;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Fire;
import mindustry.gen.Firec;
import mindustry.gen.Posc;
import mindustry.gen.Sounds;
import mindustry.gen.Syncc;
import mindustry.gen.Timedc;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.meta.Attribute;

abstract class FireComp
implements Timedc,
Posc,
Firec,
Syncc {
    private static final float spreadChance = 0.04f;
    private static final float fireballChance = 0.06f;
    float time;
    float lifetime;
    float x;
    float y;
    Tile tile;
    private transient Block block;
    private transient float baseFlammability = -1.0f;
    private transient float puddleFlammability;

    FireComp() {
    }

    @Override
    public void update() {
        Object p;
        if (Mathf.chance(0.09 * (double)Time.delta)) {
            Fx.fire.at(this.x + Mathf.range(4.0f), this.y + Mathf.range(4.0f));
        }
        if (Mathf.chance(0.05 * (double)Time.delta)) {
            Fx.fireSmoke.at(this.x + Mathf.range(4.0f), this.y + Mathf.range(4.0f));
        }
        if (!Vars.headless) {
            Vars.control.sound.loop(Sounds.fire, this, 0.07f);
        }
        float speedMultiplier = 1.0f + Math.max(Vars.state.envAttrs.get(Attribute.water) * 10.0f, 0.0f);
        this.time = Mathf.clamp(this.time + Time.delta * speedMultiplier, 0.0f, this.lifetime);
        if (Vars.net.client()) {
            return;
        }
        if (this.time >= this.lifetime || this.tile == null) {
            this.remove();
            return;
        }
        Building entity = this.tile.build;
        boolean damage = entity != null;
        float flammability = this.baseFlammability + this.puddleFlammability;
        if (!damage && flammability <= 0.0f) {
            this.time += Time.delta * 8.0f;
        }
        if (this.baseFlammability < 0.0f || this.block != this.tile.block()) {
            this.baseFlammability = this.tile.build == null ? 0.0f : this.tile.getFlammability();
            this.block = this.tile.block();
        }
        if (damage) {
            this.lifetime += Mathf.clamp(flammability / 8.0f, 0.0f, 0.6f) * Time.delta;
        }
        if (flammability > 1.0f && Mathf.chance(0.04f * Time.delta * Mathf.clamp(flammability / 5.0f, 0.3f, 2.0f))) {
            p = Geometry.d4[Mathf.random(3)];
            Tile other = Vars.world.tile(this.tile.x + ((Point2)p).x, this.tile.y + ((Point2)p).y);
            Fires.create(other);
            if (Mathf.chance(0.06f * Time.delta * Mathf.clamp(flammability / 10.0f))) {
                Bullets.fireball.createNet(Team.derelict, this.x, this.y, Mathf.random(360.0f), -1.0f, 1.0f, 1.0f);
            }
        }
        if (Mathf.chance(0.025 * (double)Time.delta)) {
            p = Puddles.get(this.tile);
            float f = this.puddleFlammability = p != null ? p.getFlammability() / 3.0f : 0.0f;
            if (damage) {
                entity.damage(1.6f);
            }
            Damage.damageUnits(null, this.tile.worldx(), this.tile.worldy(), 8.0f, 3.0f, unit -> !unit.isFlying() && !unit.isImmune(StatusEffects.burning), unit -> unit.apply(StatusEffects.burning, 300.0f));
        }
    }

    @Override
    public void remove() {
        Fires.remove(this.tile);
    }

    @Override
    public void afterRead() {
        Fires.register((Fire)this.self());
    }

    @Override
    public void afterSync() {
        Fires.register((Fire)this.self());
    }
}

