/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.Events;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.game.EventType;
import mindustry.gen.Healthc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Posc;
import mindustry.gen.Unit;
import mindustry.gen.Velc;
import mindustry.gen.WaterMovec;
import mindustry.world.blocks.environment.Floor;

abstract class FlyingComp
implements Posc,
Velc,
Healthc,
Hitboxc {
    private static final Vec2 tmp1 = new Vec2();
    private static final Vec2 tmp2 = new Vec2();
    float x;
    float y;
    float speedMultiplier;
    Vec2 vel;
    float elevation;
    private transient boolean wasFlying;
    transient boolean hovering;
    transient float drownTime;
    transient float splashTimer;

    FlyingComp() {
    }

    boolean checkTarget(boolean targetAir, boolean targetGround) {
        return this.isGrounded() && targetGround || this.isFlying() && targetAir;
    }

    boolean isGrounded() {
        return this.elevation < 0.001f;
    }

    boolean isFlying() {
        return this.elevation >= 0.09f;
    }

    boolean canDrown() {
        return this.isGrounded() && !this.hovering;
    }

    void landed() {
    }

    void wobble() {
        this.x += Mathf.sin(Time.time + (float)(this.id() % 10 * 12), 25.0f, 0.05f) * Time.delta * this.elevation;
        this.y += Mathf.cos(Time.time + (float)(this.id() % 10 * 12), 25.0f, 0.05f) * Time.delta * this.elevation;
    }

    void moveAt(Vec2 vector, float acceleration) {
        Vec2 t = tmp1.set(vector);
        tmp2.set(t).sub(this.vel).limit(acceleration * vector.len() * Time.delta * this.floorSpeedMultiplier());
        this.vel.add(tmp2);
    }

    float floorSpeedMultiplier() {
        Floor on = this.isFlying() || this.hovering ? Blocks.air.asFloor() : this.floorOn();
        return on.speedMultiplier * this.speedMultiplier;
    }

    @Override
    public void update() {
        Floor floor = this.floorOn();
        if (this.isFlying() != this.wasFlying) {
            if (this.wasFlying && this.tileOn() != null) {
                Fx.unitLand.at(this.x, this.y, this.floorOn().isLiquid ? 1.0f : 0.5f, this.tileOn().floor().mapColor);
            }
            this.wasFlying = this.isFlying();
        }
        if (!this.hovering && this.isGrounded()) {
            float f;
            this.splashTimer += Mathf.dst(this.deltaX(), this.deltaY());
            if (f >= 7.0f + this.hitSize() / 8.0f) {
                floor.walkEffect.at(this.x, this.y, this.hitSize() / 8.0f, floor.mapColor);
                this.splashTimer = 0.0f;
                if (!(this instanceof WaterMovec)) {
                    floor.walkSound.at(this.x, this.y, Mathf.random(floor.walkSoundPitchMin, floor.walkSoundPitchMax), floor.walkSoundVolume);
                }
            }
        }
        if (this.canDrown() && floor.isLiquid && floor.drownTime > 0.0f) {
            this.drownTime += Time.delta / floor.drownTime;
            this.drownTime = Mathf.clamp(this.drownTime);
            if (Mathf.chanceDelta(0.05f)) {
                floor.drownUpdateEffect.at(this.x, this.y, 1.0f, floor.mapColor);
            }
            if (this.drownTime >= 0.999f && !Vars.net.client()) {
                this.kill();
                Events.fire(new EventType.UnitDrownEvent((Unit)this.self()));
            }
        } else {
            this.drownTime = Mathf.lerpDelta(this.drownTime, 0.0f, 0.03f);
        }
    }
}

