/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.func.Cons;
import arc.math.Mathf;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import mindustry.entities.comp.Sized;
import mindustry.gen.Hitboxc;
import mindustry.gen.Posc;

abstract class HitboxComp
implements Posc,
Sized,
QuadTree.QuadTreeObject {
    float x;
    float y;
    transient float lastX;
    transient float lastY;
    transient float deltaX;
    transient float deltaY;
    transient float hitSize;

    HitboxComp() {
    }

    @Override
    public void update() {
    }

    @Override
    public void add() {
        this.updateLastPosition();
    }

    @Override
    public void afterRead() {
        this.updateLastPosition();
    }

    @Override
    public float hitSize() {
        return this.hitSize;
    }

    void getCollisions(Cons<QuadTree> consumer) {
    }

    void updateLastPosition() {
        this.deltaX = this.x - this.lastX;
        this.deltaY = this.y - this.lastY;
        this.lastX = this.x;
        this.lastY = this.y;
    }

    void collision(Hitboxc other, float x, float y) {
    }

    float deltaLen() {
        return Mathf.len(this.deltaX, this.deltaY);
    }

    float deltaAngle() {
        return Mathf.angle(this.deltaX, this.deltaY);
    }

    boolean collides(Hitboxc other) {
        return true;
    }

    @Override
    public void hitbox(Rect rect) {
        rect.setCentered(this.x, this.y, this.hitSize, this.hitSize);
    }

    public void hitboxTile(Rect rect) {
        float size = Math.min(this.hitSize * 0.66f, 7.9f);
        rect.setCentered(this.x, this.y, size, size);
    }
}

