/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.math.Mathf;
import mindustry.gen.Posc;
import mindustry.type.Item;
import mindustry.type.ItemStack;

abstract class ItemsComp
implements Posc {
    ItemStack stack = new ItemStack();
    transient float itemTime;

    ItemsComp() {
    }

    abstract int itemCapacity();

    @Override
    public void update() {
        this.stack.amount = Mathf.clamp(this.stack.amount, 0, this.itemCapacity());
        this.itemTime = Mathf.lerpDelta(this.itemTime, Mathf.num(this.hasItem()), 0.05f);
    }

    Item item() {
        return this.stack.item;
    }

    void clearItem() {
        this.stack.amount = 0;
    }

    boolean acceptsItem(Item item) {
        return !this.hasItem() || item == this.stack.item && this.stack.amount + 1 <= this.itemCapacity();
    }

    boolean hasItem() {
        return this.stack.amount > 0;
    }

    void addItem(Item item) {
        this.addItem(item, 1);
    }

    void addItem(Item item, int amount) {
        this.stack.amount = this.stack.item == item ? this.stack.amount + amount : amount;
        this.stack.item = item;
        this.stack.amount = Mathf.clamp(this.stack.amount, 0, this.itemCapacity());
    }

    int maxAccepted(Item item) {
        return this.stack.item != item && this.stack.amount > 0 ? 0 : this.itemCapacity() - this.stack.amount;
    }
}

