/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.util.Interval;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.gen.Drawc;
import mindustry.gen.Timedc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.ui.Cicon;
import mindustry.world.Block;

abstract class LaunchCoreComp
implements Drawc,
Timedc {
    float x;
    float y;
    transient Interval in = new Interval();
    Block block;

    LaunchCoreComp() {
    }

    @Override
    public void draw() {
        float alpha = this.fout(Interp.pow5Out);
        float scale = (1.0f - alpha) * 1.4f + 1.0f;
        float cx = this.cx();
        float cy = this.cy();
        float rotation = this.fin() * (140.0f + Mathf.randomSeedRange(this.id(), 50.0f));
        Draw.z(110.001f);
        Draw.color(Pal.engine);
        float rad = 0.2f + this.fslope();
        float rscl = (float)(this.block.size - 1) * 0.85f;
        Fill.light(cx, cy, 10, 25.0f * (rad + scale - 1.0f) * rscl, Tmp.c2.set(Pal.engine).a(alpha), Tmp.c1.set(Pal.engine).a(0.0f));
        Draw.alpha(alpha);
        for (int i = 0; i < 4; ++i) {
            Drawf.tri(cx, cy, 6.0f * rscl, 40.0f * (rad + scale - 1.0f) * rscl, (float)i * 90.0f + rotation);
        }
        Draw.color();
        Draw.z(129.0f);
        TextureRegion region = this.block.icon(Cicon.full);
        float rw = (float)region.width * Draw.scl * scale;
        float rh = (float)region.height * Draw.scl * scale;
        Draw.alpha(alpha);
        Draw.rect(region, cx, cy, rw, rh, rotation - 45.0f);
        Tmp.v1.trns(225.0f, this.fin(Interp.pow3In) * 250.0f);
        Draw.z(116.0f);
        Draw.color(0.0f, 0.0f, 0.0f, 0.22f * alpha);
        Draw.rect(region, cx + Tmp.v1.x, cy + Tmp.v1.y, rw, rh, rotation - 45.0f);
        Draw.reset();
    }

    float cx() {
        return this.x + this.fin(Interp.pow2In) * (12.0f + Mathf.randomSeedRange(this.id() + 3, 4.0f));
    }

    float cy() {
        return this.y + this.fin(Interp.pow5In) * (100.0f + Mathf.randomSeedRange(this.id() + 2, 30.0f));
    }

    @Override
    public void update() {
        float r = 4.0f;
        if (this.in.get(3.0f - this.fin() * 2.0f)) {
            Fx.rocketSmokeLarge.at(this.cx() + Mathf.range(r), this.cy() + Mathf.range(r), this.fin());
        }
    }
}

