/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.graphics.Color;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.gen.ElevationMovec;
import mindustry.gen.Flyingc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Mechc;
import mindustry.gen.Posc;
import mindustry.gen.Unitc;
import mindustry.type.UnitType;
import mindustry.world.Tile;

abstract class MechComp
implements Posc,
Flyingc,
Hitboxc,
Unitc,
Mechc,
ElevationMovec {
    float x;
    float y;
    float hitSize;
    UnitType type;
    float baseRotation;
    transient float walkTime;
    transient float walkExtension;
    private transient boolean walked;

    MechComp() {
    }

    @Override
    public void update() {
        float lastExtend;
        if (this.walked || Vars.net.client()) {
            float len = this.deltaLen();
            this.baseRotation = Angles.moveToward(this.baseRotation, this.deltaAngle(), this.type().baseRotateSpeed * Mathf.clamp(len / this.type().speed / Time.delta) * Time.delta);
            this.walkTime += len;
            this.walked = false;
        }
        float extend = this.walkExtend(false);
        float base = this.walkExtend(true);
        float extendScl = base % 1.0f;
        if (extendScl < (lastExtend = this.walkExtension) && base % 2.0f > 1.0f && !this.isFlying()) {
            Tile tile;
            int side = -Mathf.sign(extend);
            float width = this.hitSize / 2.0f * (float)side;
            float length = this.type.mechStride * 1.35f;
            float cx = this.x + Angles.trnsx(this.baseRotation, length, width);
            float cy = this.y + Angles.trnsy(this.baseRotation, length, width);
            if (this.type.mechStepShake > 0.0f) {
                Effect.shake(this.type.mechStepShake, this.type.mechStepShake, cx, cy);
            }
            if (this.type.mechStepParticles && (tile = Vars.world.tileWorld(cx, cy)) != null) {
                Color color = tile.floor().mapColor;
                Fx.unitLand.at(cx, cy, this.hitSize / 8.0f, color);
            }
        }
        this.walkExtension = extendScl;
    }

    @Override
    public float walkExtend(boolean scaled) {
        float raw = this.walkTime % (this.type.mechStride * 4.0f);
        if (scaled) {
            return raw / this.type.mechStride;
        }
        if (raw > this.type.mechStride * 3.0f) {
            raw -= this.type.mechStride * 4.0f;
        } else if (raw > this.type.mechStride * 2.0f) {
            raw = this.type.mechStride * 2.0f - raw;
        } else if (raw > this.type.mechStride) {
            raw = this.type.mechStride * 2.0f - raw;
        }
        return raw;
    }

    @Override
    public void moveAt(Vec2 vector, float acceleration) {
        if (!vector.isZero()) {
            this.walked = true;
        }
    }

    @Override
    public void approach(Vec2 vector) {
        if (!vector.isZero(0.001f)) {
            this.walked = true;
        }
    }
}

