/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Nullable;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Drawc;
import mindustry.gen.Itemsc;
import mindustry.gen.Posc;
import mindustry.gen.Rotc;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.InputHandler;
import mindustry.type.Item;
import mindustry.type.UnitType;
import mindustry.world.Tile;

abstract class MinerComp
implements Itemsc,
Posc,
Teamc,
Rotc,
Drawc {
    float x;
    float y;
    float rotation;
    float hitSize;
    UnitType type;
    transient float mineTimer;
    @Nullable
    Tile mineTile;

    MinerComp() {
    }

    public boolean canMine(Item item) {
        return this.type.mineTier >= item.hardness;
    }

    public boolean offloadImmediately() {
        return ((Unit)this.self()).isPlayer();
    }

    boolean mining() {
        return this.mineTile != null && !((Unit)this.self()).activelyBuilding();
    }

    public boolean validMine(Tile tile, boolean checkDst) {
        return tile != null && tile.block() == Blocks.air && (this.within(tile.worldx(), tile.worldy(), 70.0f) || !checkDst) && tile.drop() != null && this.canMine(tile.drop());
    }

    public boolean validMine(Tile tile) {
        return this.validMine(tile, true);
    }

    public boolean canMine() {
        return this.type.mineSpeed > 0.0f && this.type.mineTier >= 0;
    }

    @Override
    public void update() {
        int accepted;
        Building core = this.closestCore();
        if (core != null && this.mineTile != null && this.mineTile.drop() != null && !this.acceptsItem(this.mineTile.drop()) && this.within(core, 220.0f) && !this.offloadImmediately() && (accepted = core.acceptStack(this.item(), this.stack().amount, this)) > 0) {
            Call.transferItemTo((Unit)this.self(), this.item(), accepted, this.mineTile.worldx() + Mathf.range(4.0f), this.mineTile.worldy() + Mathf.range(4.0f), core);
            this.clearItem();
        }
        if (!this.validMine(this.mineTile)) {
            this.mineTile = null;
            this.mineTimer = 0.0f;
        } else if (this.mining()) {
            Item item = this.mineTile.drop();
            this.mineTimer += Time.delta * this.type.mineSpeed;
            if (Mathf.chance(0.06 * (double)Time.delta)) {
                Fx.pulverizeSmall.at(this.mineTile.worldx() + Mathf.range(4.0f), this.mineTile.worldy() + Mathf.range(4.0f), 0.0f, item.color);
            }
            if (this.mineTimer >= 50.0f + (float)item.hardness * 15.0f) {
                this.mineTimer = 0.0f;
                if (Vars.state.rules.sector != null && this.team() == Vars.state.rules.defaultTeam) {
                    Vars.state.rules.sector.info.handleProduction(item, 1);
                }
                if (core != null && this.within(core, 220.0f) && core.acceptStack(item, 1, this) == 1 && this.offloadImmediately()) {
                    if (this.item() == item && !Vars.net.client()) {
                        this.addItem(item);
                    }
                    Call.transferItemTo((Unit)this.self(), item, 1, this.mineTile.worldx() + Mathf.range(4.0f), this.mineTile.worldy() + Mathf.range(4.0f), core);
                } else if (this.acceptsItem(item)) {
                    InputHandler.transferItemToUnit(item, this.mineTile.worldx() + Mathf.range(4.0f), this.mineTile.worldy() + Mathf.range(4.0f), this);
                } else {
                    this.mineTile = null;
                    this.mineTimer = 0.0f;
                }
            }
            if (!Vars.headless) {
                Vars.control.sound.loop(this.type.mineSound, this, this.type.mineSoundVolume);
            }
        }
    }

    @Override
    public void draw() {
        if (!this.mining()) {
            return;
        }
        float focusLen = this.hitSize / 2.0f + Mathf.absin(Time.time, 1.1f, 0.5f);
        float swingScl = 12.0f;
        float swingMag = 1.0f;
        float flashScl = 0.3f;
        float px = this.x + Angles.trnsx(this.rotation, focusLen);
        float py = this.y + Angles.trnsy(this.rotation, focusLen);
        float ex = this.mineTile.worldx() + Mathf.sin(Time.time + 48.0f, swingScl, swingMag);
        float ey = this.mineTile.worldy() + Mathf.sin(Time.time + 48.0f, swingScl + 2.0f, swingMag);
        Draw.z(115.1f);
        Draw.color(Color.lightGray, Color.white, 1.0f - flashScl + Mathf.absin(Time.time, 0.5f, flashScl));
        Drawf.laser(this.team(), Core.atlas.find("minelaser"), Core.atlas.find("minelaser-end"), px, py, ex, ey, 0.75f);
        if (this.isLocal()) {
            Lines.stroke(1.0f, Pal.accent);
            Lines.poly(this.mineTile.worldx(), this.mineTile.worldy(), 4, 4.0f * Mathf.sqrt2, Time.time);
        }
        Draw.color();
    }
}

