/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.Events;
import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.entities.EntityGroup;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.gen.Hitboxc;
import mindustry.gen.Posc;
import mindustry.gen.Rotc;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustry.type.UnitType;
import mindustry.ui.Cicon;
import mindustry.world.Build;
import mindustry.world.Tile;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.UnitPayload;

abstract class PayloadComp
implements Posc,
Rotc,
Hitboxc,
Unitc {
    float x;
    float y;
    float rotation;
    UnitType type;
    Seq<Payload> payloads = new Seq();

    PayloadComp() {
    }

    float payloadUsed() {
        return this.payloads.sumf(p -> p.size() * p.size());
    }

    boolean canPickup(Unit unit) {
        return this.payloadUsed() + unit.hitSize * unit.hitSize <= this.type.payloadCapacity + 0.001f && unit.team == this.team() && unit.isAI();
    }

    boolean canPickup(Building build) {
        return this.payloadUsed() + (float)(build.block.size * build.block.size * 8 * 8) <= this.type.payloadCapacity + 0.001f && build.canPickup();
    }

    boolean canPickupPayload(Payload pay) {
        return this.payloadUsed() + pay.size() * pay.size() <= this.type.payloadCapacity + 0.001f;
    }

    boolean hasPayload() {
        return this.payloads.size > 0;
    }

    void addPayload(Payload load) {
        this.payloads.add(load);
    }

    void pickup(Unit unit) {
        unit.remove();
        this.payloads.add(new UnitPayload(unit));
        Fx.unitPickup.at(unit);
        if (Vars.net.client()) {
            Vars.netClient.clearRemovedEntity(unit.id);
        }
        Events.fire(new EventType.PickupEvent((Unit)this.self(), unit));
    }

    void pickup(Building tile) {
        tile.pickedUp();
        tile.tile.remove();
        this.payloads.add(new BuildPayload(tile));
        Fx.unitPickup.at(tile);
        Events.fire(new EventType.PickupEvent((Unit)this.self(), tile));
    }

    boolean dropLastPayload() {
        if (this.payloads.isEmpty()) {
            return false;
        }
        Payload load = this.payloads.peek();
        if (this.tryDropPayload(load)) {
            this.payloads.pop();
            return true;
        }
        return false;
    }

    boolean tryDropPayload(Payload payload) {
        UnitPayload p;
        BuildPayload b;
        Tile on = this.tileOn();
        if (Vars.net.client() && payload instanceof UnitPayload) {
            Vars.netClient.clearRemovedEntity(((UnitPayload)payload).unit.id);
        }
        if (on != null && on.build != null && on.build.acceptPayload(on.build, payload)) {
            Fx.unitDrop.at(on.build);
            on.build.handlePayload(on.build, payload);
            return true;
        }
        Payload payload2 = payload;
        if (payload2 instanceof BuildPayload && (b = (BuildPayload)payload2) == (BuildPayload)payload2) {
            return this.dropBlock(b);
        }
        payload2 = payload;
        if (payload2 instanceof UnitPayload && (p = (UnitPayload)payload2) == (UnitPayload)payload2) {
            return this.dropUnit(p);
        }
        return false;
    }

    boolean dropUnit(UnitPayload payload) {
        Unit u = payload.unit;
        if (!u.canPass(this.tileX(), this.tileY())) {
            return false;
        }
        Fx.unitDrop.at(this);
        if (Vars.net.client()) {
            return true;
        }
        u.set(this);
        u.trns(Tmp.v1.rnd(Mathf.random(2.0f)));
        u.rotation(this.rotation);
        u.id = EntityGroup.nextId();
        if (!u.isAdded()) {
            u.team.data().updateCount(u.type, -1);
        }
        u.add();
        return true;
    }

    boolean dropBlock(BuildPayload payload) {
        int ty;
        Building tile = payload.build;
        int tx = World.toTile(this.x - tile.block.offset);
        Tile on = Vars.world.tile(tx, ty = World.toTile(this.y - tile.block.offset));
        if (on != null && Build.validPlace(tile.block, tile.team, tx, ty, tile.rotation, false)) {
            int rot = (int)((this.rotation + 45.0f) / 90.0f) % 4;
            payload.place(on, rot);
            if (this.getControllerName() != null) {
                payload.build.lastAccessed = this.getControllerName();
            }
            Fx.unitDrop.at(tile);
            Fx.placeBlock.at(on.drawx(), on.drawy(), on.block().size);
            return true;
        }
        return false;
    }

    void contentInfo(Table table, float itemSize, float width) {
        table.clear();
        table.top().left();
        float pad = 0.0f;
        float items = this.payloads.size;
        if (itemSize * items + pad * items > width) {
            pad = (width - itemSize * items) / items;
        }
        for (Payload p : this.payloads) {
            table.image(p.icon(Cicon.small)).size(itemSize).padRight(pad);
        }
    }
}

