/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.ui.layout.Scl;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.Time;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.ai.formations.Formation;
import mindustry.content.UnitTypes;
import mindustry.core.NetClient;
import mindustry.entities.units.UnitController;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Call;
import mindustry.gen.Drawc;
import mindustry.gen.Entityc;
import mindustry.gen.Icon;
import mindustry.gen.Nulls;
import mindustry.gen.Player;
import mindustry.gen.Syncc;
import mindustry.gen.Timerc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.net.Administration;
import mindustry.net.NetConnection;
import mindustry.net.Packets;
import mindustry.ui.Cicon;
import mindustry.ui.Fonts;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;

abstract class PlayerComp
implements UnitController,
Entityc,
Syncc,
Timerc,
Drawc {
    static final float deathDelay = 60.0f;
    float x;
    float y;
    Unit unit = Nulls.unit;
    private transient Unit lastReadUnit = Nulls.unit;
    @Nullable
    transient NetConnection con;
    Team team = Team.sharded;
    boolean typing;
    boolean shooting;
    boolean boosting;
    boolean admin;
    float mouseX;
    float mouseY;
    String name = "noname";
    Color color = new Color();
    transient String locale = "en";
    transient float deathTimer;
    transient String lastText = "";
    transient float textFadeTime;

    PlayerComp() {
    }

    public boolean isBuilder() {
        return this.unit.canBuild();
    }

    @Nullable
    public CoreBlock.CoreBuild closestCore() {
        return Vars.state.teams.closestCore(this.x, this.y, this.team);
    }

    @Nullable
    public CoreBlock.CoreBuild core() {
        return this.team.core();
    }

    @Nullable
    public CoreBlock.CoreBuild bestCore() {
        return this.team.cores().min(Structs.comps(Structs.comparingInt(c -> -c.block.size), Structs.comparingFloat(c -> c.dst(this.x, this.y))));
    }

    public TextureRegion icon() {
        if (this.dead()) {
            return this.core() == null ? UnitTypes.alpha.icon(Cicon.full) : ((CoreBlock)this.core().block).unitType.icon(Cicon.full);
        }
        return this.unit.icon();
    }

    public boolean displayAmmo() {
        return this.unit instanceof BlockUnitc || Vars.state.rules.unitAmmo;
    }

    public void reset() {
        this.team = Vars.state.rules.defaultTeam;
        this.typing = false;
        this.admin = false;
        this.textFadeTime = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        if (!this.dead()) {
            this.unit.controller(this.unit.type.createController());
            this.unit = Nulls.unit;
        }
    }

    @Override
    public boolean isValidController() {
        return this.isAdded();
    }

    @Override
    public float clipSize() {
        return this.unit.isNull() ? 20.0f : this.unit.type.hitSize * 2.0f;
    }

    @Override
    public void afterSync() {
        Unit set = this.unit;
        this.unit = this.lastReadUnit;
        this.unit(set);
        this.lastReadUnit = this.unit;
        this.unit.aim(this.mouseX, this.mouseY);
        this.unit.controlWeapons(this.shooting, this.shooting);
        Formation formation = this.unit.formation;
        this.unit.controller(this);
        this.unit.formation = formation;
    }

    @Override
    public void update() {
        if (!this.unit.isValid()) {
            this.clearUnit();
        }
        if (!this.dead()) {
            this.set(this.unit);
            this.unit.team(this.team);
            this.deathTimer = 0.0f;
            if (this.unit.type.canBoost) {
                Tile tile = this.unit.tileOn();
                this.unit.elevation = Mathf.approachDelta(this.unit.elevation, tile != null && tile.solid() || this.boosting ? 1.0f : 0.0f, this.unit.type.riseSpeed);
            }
        } else {
            CoreBlock.CoreBuild core = this.bestCore();
            if (core != null) {
                this.deathTimer += Time.delta;
                if (this.deathTimer >= 60.0f) {
                    core.requestSpawn((Player)this.self());
                    this.deathTimer = 0.0f;
                }
            }
        }
        this.textFadeTime -= Time.delta / 300.0f;
    }

    @Override
    public void remove() {
        if (!this.unit.isNull()) {
            this.clearUnit();
        }
    }

    public void team(Team team) {
        this.team = team;
        this.unit.team(team);
    }

    public void clearUnit() {
        this.unit(Nulls.unit);
    }

    @Override
    public Unit unit() {
        return this.unit;
    }

    @Override
    public void unit(Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit cannot be null. Use clearUnit() instead.");
        }
        if (this.unit == unit) {
            return;
        }
        if (this.unit != Nulls.unit) {
            this.unit.controller(this.unit.type.createController());
        }
        this.unit = unit;
        if (unit != Nulls.unit) {
            unit.team(this.team);
            unit.controller(this);
            if (unit.isRemote()) {
                unit.snapInterpolation();
            }
            if (!Vars.headless && this.isLocal()) {
                Vars.control.input.block = null;
            }
        }
        Events.fire(new EventType.UnitChangeEvent((Player)this.self(), unit));
    }

    boolean dead() {
        return this.unit.isNull() || !this.unit.isValid();
    }

    String ip() {
        return this.con == null ? "localhost" : this.con.address;
    }

    String uuid() {
        return this.con == null ? "[LOCAL]" : this.con.uuid;
    }

    String usid() {
        return this.con == null ? "[LOCAL]" : this.con.usid;
    }

    void kick(Packets.KickReason reason) {
        this.con.kick(reason);
    }

    void kick(String reason) {
        this.con.kick(reason);
    }

    void kick(String reason, long duration) {
        this.con.kick(reason, duration);
    }

    @Override
    public void draw() {
        Draw.z(150.0f);
        float z = Drawf.text();
        Font font = Fonts.def;
        GlyphLayout layout = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        float nameHeight = 11.0f;
        float textHeight = 15.0f;
        boolean ints = font.usesIntegerPositions();
        font.setUseIntegerPositions(false);
        font.getData().setScale(0.25f / Scl.scl(1.0f));
        layout.setText(font, this.name);
        if (!this.isLocal()) {
            Draw.color(0.0f, 0.0f, 0.0f, 0.3f);
            Fill.rect(this.unit.x, this.unit.y + 11.0f - layout.height / 2.0f, layout.width + 2.0f, layout.height + 3.0f);
            Draw.color();
            font.setColor(this.color);
            font.draw(this.name, this.unit.x, this.unit.y + 11.0f, 0.0f, 1, false);
            if (this.admin) {
                float s = 3.0f;
                Draw.color(this.color.r * 0.5f, this.color.g * 0.5f, this.color.b * 0.5f, 1.0f);
                Draw.rect(Icon.adminSmall.getRegion(), this.unit.x + layout.width / 2.0f + 2.0f + 1.0f, this.unit.y + 11.0f - 1.5f, s, s);
                Draw.color(this.color);
                Draw.rect(Icon.adminSmall.getRegion(), this.unit.x + layout.width / 2.0f + 2.0f + 1.0f, this.unit.y + 11.0f - 1.0f, s, s);
            }
        }
        if (Core.settings.getBool("playerchat") && (this.textFadeTime > 0.0f && this.lastText != null || this.typing)) {
            String text = this.textFadeTime <= 0.0f || this.lastText == null ? "[lightgray]" + Strings.animated(Time.time, 4, 15.0f, ".") : this.lastText;
            float width = 100.0f;
            float visualFadeTime = 1.0f - Mathf.curve(1.0f - this.textFadeTime, 0.9f);
            font.setColor(1.0f, 1.0f, 1.0f, this.textFadeTime <= 0.0f || this.lastText == null ? 1.0f : visualFadeTime);
            layout.setText(font, text, Color.white, width, 4, true);
            Draw.color(0.0f, 0.0f, 0.0f, 0.3f * (this.textFadeTime <= 0.0f || this.lastText == null ? 1.0f : visualFadeTime));
            Fill.rect(this.unit.x, this.unit.y + 15.0f + layout.height - layout.height / 2.0f, layout.width + 2.0f, layout.height + 3.0f);
            font.draw(text, this.unit.x - width / 2.0f, this.unit.y + 15.0f + layout.height, width, 1, true);
        }
        Draw.reset();
        Pools.free(layout);
        font.getData().setScale(1.0f);
        font.setColor(Color.white);
        font.setUseIntegerPositions(ints);
        Draw.z(z);
    }

    void sendMessage(String text) {
        if (this.isLocal()) {
            if (Vars.ui != null) {
                Vars.ui.chatfrag.addMessage(text, null);
            }
        } else {
            Call.sendMessage(this.con, text, null, null);
        }
    }

    void sendMessage(String text, Player from) {
        this.sendMessage(text, from, NetClient.colorizeName(from.id(), from.name));
    }

    void sendMessage(String text, Player from, String fromName) {
        if (this.isLocal()) {
            if (Vars.ui != null) {
                Vars.ui.chatfrag.addMessage(text, fromName);
            }
        } else {
            Call.sendMessage(this.con, text, fromName, from);
        }
    }

    Administration.PlayerInfo getInfo() {
        if (this.isLocal()) {
            throw new IllegalArgumentException("Local players cannot be traced and do not have info.");
        }
        return Vars.netServer.admins.getInfo(this.uuid());
    }
}

