/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.math.geom.Position;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.core.World;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;

abstract class PosComp
implements Position {
    float x;
    float y;

    PosComp() {
    }

    void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    int tileX() {
        return World.toTile(this.x);
    }

    int tileY() {
        return World.toTile(this.y);
    }

    Floor floorOn() {
        Tile tile = this.tileOn();
        return tile == null || tile.block() != Blocks.air ? (Floor)Blocks.air : tile.floor();
    }

    Block blockOn() {
        Tile tile = this.tileOn();
        return tile == null ? Blocks.air : tile.block();
    }

    boolean onSolid() {
        Tile tile = this.tileOn();
        return tile == null || tile.solid();
    }

    @Nullable
    Tile tileOn() {
        return Vars.world.tileWorld(this.x, this.y);
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }
}

