/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Rect;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.entities.Fires;
import mindustry.entities.Puddles;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Drawc;
import mindustry.gen.Posc;
import mindustry.gen.Puddle;
import mindustry.gen.Puddlec;
import mindustry.graphics.Drawf;
import mindustry.type.Liquid;
import mindustry.world.Tile;

abstract class PuddleComp
implements Posc,
Puddlec,
Drawc {
    private static final int maxGeneration = 2;
    private static final Color tmp = new Color();
    private static final Rect rect = new Rect();
    private static final Rect rect2 = new Rect();
    private static int seeds;
    float x;
    float y;
    transient float accepting;
    transient float updateTime;
    transient float lastRipple;
    float amount;
    int generation;
    Tile tile;
    Liquid liquid;

    PuddleComp() {
    }

    @Override
    public float getFlammability() {
        return this.liquid.flammability * this.amount;
    }

    @Override
    public void update() {
        float addSpeed = this.accepting > 0.0f ? 3.0f : 0.0f;
        this.amount -= Time.delta * (1.0f - this.liquid.viscosity) / (5.0f + addSpeed);
        this.amount += this.accepting;
        this.accepting = 0.0f;
        if (this.amount >= 46.666668f && this.generation < 2) {
            float deposited = Math.min((this.amount - 46.666668f) / 4.0f, 0.3f) * Time.delta;
            for (Point2 point : Geometry.d4) {
                Tile other = Vars.world.tile(this.tile.x + point.x, this.tile.y + point.y);
                if (other == null || other.block() != Blocks.air) continue;
                Puddles.deposit(other, this.tile, this.liquid, deposited, this.generation + 1);
                this.amount -= deposited / 2.0f;
            }
        }
        this.amount = Mathf.clamp(this.amount, 0.0f, 70.0f);
        if (this.amount <= 0.0f) {
            this.remove();
        }
        if (this.amount >= 35.0f && this.updateTime <= 0.0f) {
            Units.nearby(rect.setSize(Mathf.clamp(this.amount / 46.666668f) * 10.0f).setCenter(this.x, this.y), unit -> {
                if (unit.isGrounded() && !unit.hovering) {
                    unit.hitbox(rect2);
                    if (rect.overlaps(rect2)) {
                        unit.apply(this.liquid.effect, 120.0f);
                        if ((double)unit.vel.len() > 0.1) {
                            Fx.ripple.at(unit.x, unit.y, unit.type.rippleScale, this.liquid.color);
                        }
                    }
                }
            });
            if (this.liquid.temperature > 0.7f && this.tile.build != null && Mathf.chance(0.5)) {
                Fires.create(this.tile);
            }
            this.updateTime = 40.0f;
        }
        this.updateTime -= Time.delta;
    }

    @Override
    public void draw() {
        Draw.z(19.0f);
        seeds = this.id();
        boolean onLiquid = this.tile.floor().isLiquid;
        float f = Mathf.clamp(this.amount / 46.666668f);
        float smag = onLiquid ? 0.8f : 0.0f;
        float sscl = 25.0f;
        Draw.color(tmp.set(this.liquid.color).shiftValue(-0.05f));
        Fill.circle(this.x + Mathf.sin(Time.time + (float)(seeds * 532), sscl, smag), this.y + Mathf.sin(Time.time + (float)(seeds * 53), sscl, smag), f * 8.0f);
        Angles.randLenVectors(this.id(), 3, f * 6.0f, (ex, ey) -> {
            Fill.circle(this.x + ex + Mathf.sin(Time.time + (float)(seeds * 532), sscl, smag), this.y + ey + Mathf.sin(Time.time + (float)(seeds * 53), sscl, smag), f * 5.0f);
            ++seeds;
        });
        Draw.color();
        if (this.liquid.lightColor.a > 0.001f && f > 0.0f) {
            Color color = this.liquid.lightColor;
            float opacity = color.a * f;
            Drawf.light(Team.derelict, this.tile.drawx(), this.tile.drawy(), 30.0f * f, color, opacity * 0.8f);
        }
    }

    @Override
    public float clipSize() {
        return 20.0f;
    }

    @Override
    public void remove() {
        Puddles.remove(this.tile);
    }

    @Override
    public void afterRead() {
        Puddles.register((Puddle)this.self());
    }
}

