/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.util.Time;
import mindustry.content.Fx;
import mindustry.gen.Healthc;
import mindustry.gen.Posc;

abstract class ShieldComp
implements Healthc,
Posc {
    float health;
    float hitTime;
    float x;
    float y;
    float healthMultiplier;
    boolean dead;
    float shield;
    float armor;
    transient float shieldAlpha = 0.0f;

    ShieldComp() {
    }

    @Override
    public void damage(float amount) {
        amount = Math.max(amount - this.armor, 0.1f * amount);
        this.rawDamage(amount /= this.healthMultiplier);
    }

    @Override
    public void damagePierce(float amount, boolean withEffect) {
        float pre = this.hitTime;
        this.rawDamage(amount);
        if (!withEffect) {
            this.hitTime = pre;
        }
    }

    private void rawDamage(float amount) {
        boolean hadShields;
        boolean bl = hadShields = this.shield > 1.0E-4f;
        if (hadShields) {
            this.shieldAlpha = 1.0f;
        }
        float shieldDamage = Math.min(Math.max(this.shield, 0.0f), amount);
        this.shield -= shieldDamage;
        this.hitTime = 1.0f;
        if ((amount -= shieldDamage) > 0.0f) {
            this.health -= amount;
            if (this.health <= 0.0f && !this.dead) {
                this.kill();
            }
            if (hadShields && this.shield <= 1.0E-4f) {
                Fx.unitShieldBreak.at(this.x, this.y, 0.0f, this);
            }
        }
    }

    @Override
    public void update() {
        this.shieldAlpha -= Time.delta / 15.0f;
        if (this.shieldAlpha < 0.0f) {
            this.shieldAlpha = 0.0f;
        }
    }
}

