/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.Events;
import arc.func.Cons;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.types.FormationAI;
import mindustry.ai.types.LogicAI;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.ctype.Content;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.entities.units.AIController;
import mindustry.entities.units.UnitController;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Boundedc;
import mindustry.gen.Builderc;
import mindustry.gen.Call;
import mindustry.gen.Commanderc;
import mindustry.gen.Drawc;
import mindustry.gen.Healthc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Itemsc;
import mindustry.gen.Minerc;
import mindustry.gen.Payloadc;
import mindustry.gen.Physicsc;
import mindustry.gen.Player;
import mindustry.gen.Rotc;
import mindustry.gen.Shieldc;
import mindustry.gen.Statusc;
import mindustry.gen.Syncc;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustry.gen.Weaponsc;
import mindustry.logic.LAccess;
import mindustry.logic.Ranged;
import mindustry.logic.Senseable;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.ui.Cicon;
import mindustry.ui.Displayable;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.UnitPayload;

abstract class UnitComp
implements Healthc,
Physicsc,
Hitboxc,
Statusc,
Teamc,
Itemsc,
Rotc,
Unitc,
Weaponsc,
Drawc,
Boundedc,
Syncc,
Shieldc,
Commanderc,
Displayable,
Senseable,
Ranged,
Minerc,
Builderc {
    boolean hovering;
    boolean dead;
    boolean disarmed;
    float x;
    float y;
    float rotation;
    float elevation;
    float maxHealth;
    float drag;
    float armor;
    float hitSize;
    float health;
    float ammo;
    float minFormationSpeed;
    float dragMultiplier;
    Team team;
    int id;
    @Nullable
    Tile mineTile;
    Vec2 vel;
    private UnitController controller;
    UnitType type;
    boolean spawnedByCore;
    double flag;
    transient Seq<Ability> abilities = new Seq(0);
    private transient float resupplyTime = Mathf.random(10.0f);
    private transient boolean wasPlayer;

    UnitComp() {
    }

    @Override
    public void moveAt(Vec2 vector) {
        this.moveAt(vector, this.type.accel);
    }

    @Override
    public void approach(Vec2 vector) {
        this.vel.approachDelta(vector, this.type.accel * this.realSpeed());
    }

    @Override
    public void aimLook(Position pos) {
        this.aim(pos);
        this.lookAt(pos);
    }

    @Override
    public void aimLook(float x, float y) {
        this.aim(x, y);
        this.lookAt(x, y);
    }

    @Override
    public boolean inRange(Position other) {
        return this.within(other, this.type.range);
    }

    @Override
    public boolean hasWeapons() {
        return this.type.hasWeapons();
    }

    @Override
    public float speed() {
        float strafePenalty = this.isGrounded() || !this.isPlayer() ? 1.0f : Mathf.lerp(1.0f, this.type.strafePenalty, Angles.angleDist(this.vel().angle(), this.rotation) / 180.0f);
        return (this.isCommanding() ? this.minFormationSpeed * 0.98f : this.type.speed) * strafePenalty;
    }

    @Override
    public float realSpeed() {
        return Mathf.lerp(1.0f, this.type.canBoost ? this.type.boostMultiplier : 1.0f, this.elevation) * this.speed() * this.floorSpeedMultiplier();
    }

    @Override
    public void eachGroup(Cons<Unit> cons) {
        cons.get((Unit)this.self());
        this.controlling().each(cons);
    }

    @Override
    public float prefRotation() {
        if (this.activelyBuilding()) {
            return this.angleTo(this.buildPlan());
        }
        if (this.mineTile != null) {
            return this.angleTo(this.mineTile);
        }
        if (this.moving()) {
            return this.vel().angle();
        }
        return this.rotation;
    }

    @Override
    public float range() {
        return this.type.maxRange;
    }

    @Override
    public float clipSize() {
        if (this.isBuilding()) {
            return Vars.state.rules.infiniteResources ? Float.MAX_VALUE : Math.max(this.type.clipSize, (float)this.type.region.width) + 220.0f + 32.0f;
        }
        return Math.max((float)this.type.region.width * 2.0f, this.type.clipSize);
    }

    @Override
    public double sense(LAccess sensor) {
        double d;
        switch (sensor) {
            case totalItems: {
                d = this.stack().amount;
                break;
            }
            case itemCapacity: {
                d = this.type.itemCapacity;
                break;
            }
            case rotation: {
                d = this.rotation;
                break;
            }
            case health: {
                d = this.health;
                break;
            }
            case maxHealth: {
                d = this.maxHealth;
                break;
            }
            case ammo: {
                if (!Vars.state.rules.unitAmmo) {
                    d = this.type.ammoCapacity;
                    break;
                }
                d = this.ammo;
                break;
            }
            case ammoCapacity: {
                d = this.type.ammoCapacity;
                break;
            }
            case x: {
                d = World.conv(this.x);
                break;
            }
            case y: {
                d = World.conv(this.y);
                break;
            }
            case dead: {
                if (this.dead || !this.isAdded()) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case team: {
                d = this.team.id;
                break;
            }
            case shooting: {
                if (this.isShooting()) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case boosting: {
                if (this.type.canBoost && this.isFlying()) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case range: {
                d = this.range() / 8.0f;
                break;
            }
            case shootX: {
                d = World.conv(this.aimX());
                break;
            }
            case shootY: {
                d = World.conv(this.aimY());
                break;
            }
            case mining: {
                if (this.mining()) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case mineX: {
                if (this.mining()) {
                    d = this.mineTile.x;
                    break;
                }
                d = -1.0;
                break;
            }
            case mineY: {
                if (this.mining()) {
                    d = this.mineTile.y;
                    break;
                }
                d = -1.0;
                break;
            }
            case flag: {
                d = this.flag;
                break;
            }
            case controlled: {
                if (!this.isValid()) {
                    d = 0.0;
                    break;
                }
                if (this.controller instanceof LogicAI) {
                    d = 1.0;
                    break;
                }
                if (this.controller instanceof Player) {
                    d = 2.0;
                    break;
                }
                if (this.controller instanceof FormationAI) {
                    d = 3.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case commanded: {
                if (this.controller instanceof FormationAI && this.isValid()) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case payloadCount: {
                Payloadc pay;
                Object t = this.self();
                d = t instanceof Payloadc && (pay = (Payloadc)t) == (Payloadc)t ? pay.payloads().size : 0;
                break;
            }
            case size: {
                d = this.hitSize / 8.0f;
                break;
            }
            default: {
                d = Double.NaN;
            }
        }
        return d;
    }

    @Override
    public Object senseObject(LAccess sensor) {
        Object object;
        switch (sensor) {
            case type: {
                object = this.type;
                break;
            }
            case name: {
                Player p;
                UnitController unitController = this.controller;
                if (unitController instanceof Player && (p = (Player)unitController) == (Player)unitController) {
                    object = p.name;
                    break;
                }
                object = null;
                break;
            }
            case firstItem: {
                if (this.stack().amount == 0) {
                    object = null;
                    break;
                }
                object = this.item();
                break;
            }
            case controller: {
                FormationAI form;
                LogicAI log;
                if (!this.isValid()) {
                    object = null;
                    break;
                }
                UnitController unitController = this.controller;
                if (unitController instanceof LogicAI && (log = (LogicAI)unitController) == (LogicAI)unitController) {
                    object = log.controller;
                    break;
                }
                unitController = this.controller;
                if (unitController instanceof FormationAI && (form = (FormationAI)unitController) == (FormationAI)unitController) {
                    object = form.leader;
                    break;
                }
                object = this;
                break;
            }
            case payloadType: {
                Payloadc pay;
                Object object2 = this.self();
                if (object2 instanceof Payloadc && (pay = (Payloadc)object2) == (Payloadc)object2) {
                    BuildPayload p2;
                    UnitPayload p1;
                    if (pay.payloads().isEmpty()) {
                        object = null;
                        break;
                    }
                    object2 = pay.payloads().peek();
                    if (object2 instanceof UnitPayload && (p1 = (UnitPayload)object2) == (UnitPayload)object2) {
                        object = p1.unit.type;
                        break;
                    }
                    object2 = pay.payloads().peek();
                    if (object2 instanceof BuildPayload && (p2 = (BuildPayload)object2) == (BuildPayload)object2) {
                        object = p2.block();
                        break;
                    }
                    object = null;
                    break;
                }
                object = null;
                break;
            }
            default: {
                object = noSensed;
            }
        }
        return object;
    }

    @Override
    public double sense(Content content) {
        if (content == this.stack().item) {
            return this.stack().amount;
        }
        return Double.NaN;
    }

    @Override
    public boolean canDrown() {
        return this.isGrounded() && !this.hovering && this.type.canDrown;
    }

    @Override
    public boolean canShoot() {
        return !this.disarmed && (!this.type.canBoost || !this.isFlying());
    }

    @Override
    public boolean isCounted() {
        return this.type.isCounted;
    }

    @Override
    public int itemCapacity() {
        return this.type.itemCapacity;
    }

    @Override
    public float bounds() {
        return this.hitSize * 2.0f;
    }

    @Override
    public void controller(UnitController next) {
        this.controller = next;
        if (this.controller.unit() != this.self()) {
            this.controller.unit((Unit)this.self());
        }
    }

    @Override
    public UnitController controller() {
        return this.controller;
    }

    @Override
    public void resetController() {
        this.controller(this.type.createController());
    }

    @Override
    public void set(UnitType def, UnitController controller) {
        if (this.type != def) {
            this.setType(def);
        }
        this.controller(controller);
    }

    @Override
    public int pathType() {
        return 0;
    }

    @Override
    public void lookAt(float angle) {
        this.rotation = Angles.moveToward(this.rotation, angle, this.type.rotateSpeed * Time.delta * this.speedMultiplier());
    }

    @Override
    public void lookAt(Position pos) {
        this.lookAt(this.angleTo(pos));
    }

    @Override
    public void lookAt(float x, float y) {
        this.lookAt(this.angleTo(x, y));
    }

    @Override
    public boolean isAI() {
        return this.controller instanceof AIController;
    }

    @Override
    public int count() {
        return this.team.data().countType(this.type);
    }

    @Override
    public int cap() {
        return Units.getCap(this.team);
    }

    @Override
    public void setType(UnitType type) {
        this.type = type;
        this.maxHealth = type.health;
        this.drag = type.drag;
        this.armor = type.armor;
        this.hitSize = type.hitSize;
        this.hovering = type.hovering;
        if (this.controller == null) {
            this.controller(type.createController());
        }
        if (this.mounts().length != type.weapons.size) {
            this.setupWeapons(type);
        }
        if (this.abilities.size != type.abilities.size) {
            this.abilities = type.abilities.map(Ability::copy);
        }
    }

    @Override
    public void afterSync() {
        this.setType(this.type);
        this.controller.unit((Unit)this.self());
    }

    @Override
    public void afterRead() {
        this.afterSync();
        this.controller(this.type.createController());
    }

    @Override
    public void add() {
        this.team.data().updateCount(this.type, 1);
        if (!(this.count() <= this.cap() || this.spawnedByCore || this.dead || Vars.state.rules.editor)) {
            Call.unitCapDeath((Unit)this.self());
            this.team.data().updateCount(this.type, -1);
        }
    }

    @Override
    public void remove() {
        this.team.data().updateCount(this.type, -1);
        this.controller.removed((Unit)this.self());
    }

    @Override
    public void landed() {
        if (this.type.landShake > 0.0f) {
            Effect.shake(this.type.landShake, this.type.landShake, this);
        }
        this.type.landed((Unit)this.self());
    }

    @Override
    public void update() {
        this.type.update((Unit)this.self());
        if (Vars.state.rules.unitAmmo && this.ammo < (float)this.type.ammoCapacity - 1.0E-4f) {
            this.resupplyTime += Time.delta;
            if (this.resupplyTime > 10.0f) {
                this.type.ammoType.resupply((Unit)this.self());
                this.resupplyTime = 0.0f;
            }
        }
        if (this.abilities.size > 0) {
            for (Ability ability : this.abilities) {
                ability.update((Unit)this.self());
            }
        }
        this.drag = this.type.drag * (this.isGrounded() ? this.floorOn().dragMultiplier : 1.0f) * this.dragMultiplier;
        if (this.team != Vars.state.rules.waveTeam && Vars.state.hasSpawns() && (!Vars.net.client() || this.isLocal())) {
            float relativeSize = Vars.state.rules.dropZoneRadius + this.hitSize / 2.0f + 1.0f;
            for (Tile spawn : Vars.spawner.getSpawns()) {
                if (!this.within(spawn.worldx(), spawn.worldy(), relativeSize)) continue;
                this.vel().add(Tmp.v1.set(this).sub(spawn.worldx(), spawn.worldy()).setLength(1.1f - this.dst(spawn) / relativeSize).scl(0.45f * Time.delta));
            }
        }
        if (this.dead || this.health <= 0.0f) {
            this.drag = 0.01f;
            if (Mathf.chanceDelta(0.1)) {
                Tmp.v1.setToRandomDirection().scl(this.hitSize);
                this.type.fallEffect.at(this.x + Tmp.v1.x, this.y + Tmp.v1.y);
            }
            if (Mathf.chanceDelta(0.2)) {
                float offset = this.type.engineOffset / 2.0f + this.type.engineOffset / 2.0f * this.elevation;
                float f = Mathf.range(this.type.engineSize);
                this.type.fallThrusterEffect.at(this.x + Angles.trnsx(this.rotation + 180.0f, offset) + Mathf.range(f), this.y + Angles.trnsy(this.rotation + 180.0f, offset) + Mathf.range(f), Mathf.random());
            }
            this.elevation -= this.type.fallSpeed * Time.delta;
            if (this.isGrounded()) {
                this.destroy();
            }
        }
        Tile tile = this.tileOn();
        Floor floor = this.floorOn();
        if (tile != null && this.isGrounded() && !this.type.hovering) {
            if (tile.build != null) {
                tile.build.unitOn((Unit)this.self());
            }
            if (floor.damageTaken > 0.0f) {
                this.damageContinuous(floor.damageTaken);
            }
        }
        if (tile != null && !this.canPassOn()) {
            if (this.type.canBoost) {
                this.elevation = 1.0f;
            } else if (!Vars.net.client()) {
                this.kill();
            }
        }
        if (!Vars.net.client() && !this.dead) {
            this.controller.updateUnit();
        }
        if (!this.controller.isValidController()) {
            this.resetController();
        }
        if (this.spawnedByCore && !this.isPlayer() && !this.dead) {
            Call.unitDespawn((Unit)this.self());
        }
    }

    @Override
    public TextureRegion icon() {
        return this.type.icon(Cicon.full);
    }

    @Override
    public void destroy() {
        if (!this.isAdded()) {
            return;
        }
        float explosiveness = 2.0f + this.item().explosiveness * (float)this.stack().amount * 1.53f;
        float flammability = this.item().flammability * (float)this.stack().amount / 1.9f;
        float power = this.item().charge * (float)this.stack().amount * 150.0f;
        if (!this.spawnedByCore) {
            Damage.dynamicExplosion(this.x, this.y, flammability, explosiveness, power, this.bounds() / 2.0f, Vars.state.rules.damageExplosions, this.item().flammability > 1.0f, this.team);
        }
        float shake = this.hitSize / 3.0f;
        Effect.scorch(this.x, this.y, (int)(this.hitSize / 5.0f));
        Fx.explosion.at(this);
        Effect.shake(shake, shake, this);
        this.type.deathSound.at(this);
        Events.fire(new EventType.UnitDestroyEvent((Unit)this.self()));
        if (explosiveness > 7.0f && (this.isLocal() || this.wasPlayer)) {
            Events.fire(EventType.Trigger.suicideBomb);
        }
        if (this.type.flying && !this.spawnedByCore) {
            Damage.damage(this.team, this.x, this.y, Mathf.pow(this.hitSize, 0.94f) * 1.25f, Mathf.pow(this.hitSize, 0.75f) * this.type.crashDamageMultiplier * 5.0f, true, false, true);
        }
        if (!Vars.headless) {
            for (int i = 0; i < this.type.wreckRegions.length; ++i) {
                if (!this.type.wreckRegions[i].found()) continue;
                float range = this.type.hitSize / 4.0f;
                Tmp.v1.rnd(range);
                Effect.decal(this.type.wreckRegions[i], this.x + Tmp.v1.x, this.y + Tmp.v1.y, this.rotation - 90.0f);
            }
        }
        this.remove();
    }

    @Override
    @Nullable
    public String getControllerName() {
        AIController ai;
        if (this.isPlayer()) {
            return this.getPlayer().name;
        }
        UnitController unitController = this.controller;
        if (unitController instanceof LogicAI && (ai = (LogicAI)unitController) == (LogicAI)unitController && ai.controller != null) {
            return ai.controller.lastAccessed;
        }
        unitController = this.controller;
        if (unitController instanceof FormationAI && (ai = (FormationAI)unitController) == (FormationAI)unitController && ((FormationAI)ai).leader != null && ((FormationAI)ai).leader.isPlayer()) {
            return ((FormationAI)ai).leader.getPlayer().name;
        }
        return null;
    }

    @Override
    public void display(Table table) {
        this.type.display((Unit)this.self(), table);
    }

    @Override
    public boolean isImmune(StatusEffect effect) {
        return this.type.immunities.contains(effect);
    }

    @Override
    public void draw() {
        this.type.draw((Unit)this.self());
    }

    @Override
    public boolean isPlayer() {
        return this.controller instanceof Player;
    }

    @Override
    @Nullable
    public Player getPlayer() {
        return this.isPlayer() ? (Player)this.controller : null;
    }

    @Override
    public void killed() {
        this.wasPlayer = this.isLocal();
        this.health = 0.0f;
        this.dead = true;
        if (!this.type.flying) {
            this.destroy();
        }
    }

    @Override
    public void kill() {
        if (this.dead || Vars.net.client()) {
            return;
        }
        Call.unitDeath(this.id);
    }
}

