/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.math.geom.Vec2;
import arc.util.Nullable;
import arc.util.Time;
import mindustry.Vars;
import mindustry.entities.EntityCollisions;
import mindustry.gen.Hitboxc;
import mindustry.gen.Posc;

abstract class VelComp
implements Posc {
    float x;
    float y;
    final transient Vec2 vel = new Vec2();
    transient float drag = 0.0f;

    VelComp() {
    }

    @Override
    public void update() {
        this.move(this.vel.x * Time.delta, this.vel.y * Time.delta);
        this.vel.scl(Math.max(1.0f - this.drag * Time.delta, 0.0f));
    }

    @Nullable
    EntityCollisions.SolidPred solidity() {
        return null;
    }

    boolean canPass(int tileX, int tileY) {
        EntityCollisions.SolidPred s = this.solidity();
        return s == null || !s.solid(tileX, tileY);
    }

    boolean canPassOn() {
        return this.canPass(this.tileX(), this.tileY());
    }

    boolean moving() {
        return !this.vel.isZero(0.01f);
    }

    void move(float cx, float cy) {
        EntityCollisions.SolidPred check = this.solidity();
        if (check != null) {
            Vars.collisions.move((Hitboxc)this.self(), cx, cy, check);
        } else {
            this.x += cx;
            this.y += cy;
        }
    }
}

