/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.comp;

import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.audio.SoundLoop;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.units.WeaponMount;
import mindustry.gen.Bullet;
import mindustry.gen.Posc;
import mindustry.gen.Rotc;
import mindustry.gen.Sounds;
import mindustry.gen.Statusc;
import mindustry.gen.Teamc;
import mindustry.gen.Velc;
import mindustry.type.UnitType;
import mindustry.type.Weapon;

abstract class WeaponsComp
implements Teamc,
Posc,
Rotc,
Velc,
Statusc {
    float x;
    float y;
    float rotation;
    float reloadMultiplier;
    boolean disarmed;
    Vec2 vel;
    UnitType type;
    static int sequenceNum = 0;
    WeaponMount[] mounts = new WeaponMount[0];
    transient boolean isRotate;
    transient float aimX;
    transient float aimY;
    boolean isShooting;
    float ammo;

    WeaponsComp() {
    }

    float ammof() {
        return this.ammo / (float)this.type.ammoCapacity;
    }

    void setWeaponRotation(float rotation) {
        for (WeaponMount mount : this.mounts) {
            mount.rotation = rotation;
        }
    }

    void setupWeapons(UnitType def) {
        this.mounts = new WeaponMount[def.weapons.size];
        for (int i = 0; i < this.mounts.length; ++i) {
            this.mounts[i] = new WeaponMount(def.weapons.get(i));
        }
    }

    void controlWeapons(boolean rotateShoot) {
        this.controlWeapons(rotateShoot, rotateShoot);
    }

    void controlWeapons(boolean rotate, boolean shoot) {
        for (WeaponMount mount : this.mounts) {
            mount.rotate = rotate;
            mount.shoot = shoot;
        }
        this.isRotate = rotate;
        this.isShooting = shoot;
    }

    void aim(Position pos) {
        this.aim(pos.getX(), pos.getY());
    }

    void aim(float x, float y) {
        Tmp.v1.set(x, y).sub(this.x, this.y);
        if (Tmp.v1.len() < this.type.aimDst) {
            Tmp.v1.setLength(this.type.aimDst);
        }
        x = Tmp.v1.x + this.x;
        y = Tmp.v1.y + this.y;
        for (WeaponMount mount : this.mounts) {
            mount.aimX = x;
            mount.aimY = y;
        }
        this.aimX = x;
        this.aimY = y;
    }

    boolean canShoot() {
        return !this.disarmed;
    }

    @Override
    public void remove() {
        for (WeaponMount mount : this.mounts) {
            if (mount.bullet != null) {
                mount.bullet.time = mount.bullet.lifetime - 10.0f;
                mount.bullet = null;
            }
            if (mount.sound == null) continue;
            mount.sound.stop();
        }
    }

    @Override
    public void update() {
        boolean can = this.canShoot();
        for (WeaponMount mount : this.mounts) {
            float shootAngle;
            Weapon weapon = mount.weapon;
            mount.reload = Math.max(mount.reload - Time.delta * this.reloadMultiplier, 0.0f);
            float weaponRotation = this.rotation - 90.0f + (weapon.rotate ? mount.rotation : 0.0f);
            float mountX = this.x + Angles.trnsx(this.rotation - 90.0f, weapon.x, weapon.y);
            float mountY = this.y + Angles.trnsy(this.rotation - 90.0f, weapon.x, weapon.y);
            float shootX = mountX + Angles.trnsx(weaponRotation, weapon.shootX, weapon.shootY);
            float shootY = mountY + Angles.trnsy(weaponRotation, weapon.shootX, weapon.shootY);
            float f = shootAngle = weapon.rotate ? weaponRotation + 90.0f : Angles.angle(shootX, shootY, mount.aimX, mount.aimY) + (this.rotation - this.angleTo(mount.aimX, mount.aimY));
            if (weapon.continuous && mount.bullet != null) {
                if (!mount.bullet.isAdded() || mount.bullet.time >= mount.bullet.lifetime || mount.bullet.type != weapon.bullet) {
                    mount.bullet = null;
                } else {
                    mount.bullet.rotation(weaponRotation + 90.0f);
                    mount.bullet.set(shootX, shootY);
                    mount.reload = weapon.reload;
                    this.vel.add(Tmp.v1.trns(this.rotation + 180.0f, mount.bullet.type.recoil));
                    if (weapon.shootSound != Sounds.none && !Vars.headless) {
                        if (mount.sound == null) {
                            mount.sound = new SoundLoop(weapon.shootSound, 1.0f);
                        }
                        mount.sound.update(this.x, this.y, true);
                    }
                }
            } else {
                mount.heat = Math.max(mount.heat - Time.delta * this.reloadMultiplier / mount.weapon.cooldownTime, 0.0f);
                if (mount.sound != null) {
                    mount.sound.update(this.x, this.y, false);
                }
            }
            if (weapon.otherSide != -1 && weapon.alternate && mount.side == weapon.flipSprite && mount.reload + Time.delta * this.reloadMultiplier > weapon.reload / 2.0f && mount.reload <= weapon.reload / 2.0f) {
                this.mounts[weapon.otherSide].side = !this.mounts[weapon.otherSide].side;
                boolean bl = mount.side = !mount.side;
            }
            if (weapon.rotate && (mount.rotate || mount.shoot) && can) {
                float axisX = this.x + Angles.trnsx(this.rotation - 90.0f, weapon.x, weapon.y);
                float axisY = this.y + Angles.trnsy(this.rotation - 90.0f, weapon.x, weapon.y);
                mount.targetRotation = Angles.angle(axisX, axisY, mount.aimX, mount.aimY) - this.rotation;
                mount.rotation = Angles.moveToward(mount.rotation, mount.targetRotation, weapon.rotateSpeed * Time.delta);
            } else if (!weapon.rotate) {
                mount.rotation = 0.0f;
                mount.targetRotation = this.angleTo(mount.aimX, mount.aimY);
            }
            if (!mount.shoot || !can || !(this.ammo > 0.0f) && Vars.state.rules.unitAmmo && !this.team().rules().infiniteAmmo || weapon.alternate && mount.side != weapon.flipSprite || !(this.vel.len() >= mount.weapon.minShootVelocity) && (!Vars.net.active() || this.isLocal()) || !(mount.reload <= 1.0E-4f) || !Angles.within(weapon.rotate ? mount.rotation : this.rotation, mount.targetRotation, mount.weapon.shootCone)) continue;
            this.shoot(mount, shootX, shootY, mount.aimX, mount.aimY, mountX, mountY, shootAngle, Mathf.sign(weapon.x));
            mount.reload = weapon.reload;
            this.ammo -= 1.0f;
            if (!(this.ammo < 0.0f)) continue;
            this.ammo = 0.0f;
        }
    }

    private void shoot(WeaponMount mount, float x, float y, float aimX, float aimY, float mountX, float mountY, float rotation, int side) {
        boolean delay;
        Weapon weapon = mount.weapon;
        float baseX = this.x;
        float baseY = this.y;
        boolean bl = delay = weapon.firstShotDelay + weapon.shotDelay > 0.0f;
        (delay ? weapon.chargeSound : (weapon.continuous ? Sounds.none : weapon.shootSound)).at(x, y, Mathf.random(weapon.soundPitchMin, weapon.soundPitchMax));
        BulletType ammo = weapon.bullet;
        float lifeScl = ammo.scaleVelocity ? Mathf.clamp(Mathf.dst(x, y, aimX, aimY) / ammo.range()) : 1.0f;
        sequenceNum = 0;
        if (delay) {
            Angles.shotgun(weapon.shots, weapon.spacing, rotation, f -> {
                Time.run((float)sequenceNum * weapon.shotDelay + weapon.firstShotDelay, () -> {
                    if (!this.isAdded()) {
                        return;
                    }
                    mount.bullet = this.bullet(weapon, x + this.x - baseX, y + this.y - baseY, f + Mathf.range(weapon.inaccuracy), lifeScl);
                });
                ++sequenceNum;
            });
        } else {
            Angles.shotgun(weapon.shots, weapon.spacing, rotation, f -> {
                mount.bullet = this.bullet(weapon, x, y, f + Mathf.range(weapon.inaccuracy), lifeScl);
            });
        }
        boolean parentize = ammo.keepVelocity;
        if (delay) {
            Time.run(weapon.firstShotDelay, () -> {
                if (!this.isAdded()) {
                    return;
                }
                this.vel.add(Tmp.v1.trns(rotation + 180.0f, ammo.recoil));
                Effect.shake(weapon.shake, weapon.shake, x, y);
                mount.heat = 1.0f;
                if (!weapon.continuous) {
                    weapon.shootSound.at(x, y, Mathf.random(weapon.soundPitchMin, weapon.soundPitchMax));
                }
            });
        } else {
            this.vel.add(Tmp.v1.trns(rotation + 180.0f, ammo.recoil));
            Effect.shake(weapon.shake, weapon.shake, x, y);
            mount.heat = 1.0f;
        }
        weapon.ejectEffect.at(mountX, mountY, rotation * (float)side);
        ammo.shootEffect.at(x, y, rotation, parentize ? this : null);
        ammo.smokeEffect.at(x, y, rotation, parentize ? this : null);
        this.apply(weapon.shootStatus, weapon.shootStatusDuration);
    }

    private Bullet bullet(Weapon weapon, float x, float y, float angle, float lifescl) {
        float xr = Mathf.range(weapon.xRand);
        return weapon.bullet.create(this, this.team(), x + Angles.trnsx(angle, 0.0f, xr), y + Angles.trnsy(angle, 0.0f, xr), angle, 1.0f - weapon.velocityRnd + Mathf.random(weapon.velocityRnd), lifescl);
    }
}

