/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.effect;

import mindustry.entities.Effect;

public class MultiEffect
extends Effect {
    public Effect[] effects = new Effect[0];

    public MultiEffect() {
        this.clip = 100.0f;
    }

    public MultiEffect(Effect ... effects) {
        this();
        this.effects = effects;
    }

    @Override
    public void init() {
        for (Effect f : this.effects) {
            this.clip = Math.max(this.clip, f.clip);
            this.lifetime = Math.max(this.lifetime, f.lifetime);
        }
    }

    @Override
    public void render(Effect.EffectContainer e) {
        int index = 0;
        for (Effect f : this.effects) {
            int i = ++index;
            e.scaled(f.lifetime, cont -> {
                cont.id = e.id + i;
                f.render((Effect.EffectContainer)cont);
            });
            this.clip = Math.max(this.clip, f.clip);
        }
    }
}

