/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.effect;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.util.Nullable;
import mindustry.entities.Effect;

public class ParticleEffect
extends Effect {
    public Color colorFrom = Color.white.cpy();
    public Color colorTo = Color.white.cpy();
    public int particles = 6;
    public float cone = 180.0f;
    public float length = 20.0f;
    public float baseLength = 0.0f;
    public Interp interp = Interp.linear;
    public float sizeFrom = 2.0f;
    public float sizeTo = 0.0f;
    public float offset = 0.0f;
    public String region = "circle";
    public boolean line;
    public float strokeFrom = 2.0f;
    public float strokeTo = 0.0f;
    public float lenFrom = 4.0f;
    public float lenTo = 2.0f;
    @Nullable
    private TextureRegion tex;

    @Override
    public void init() {
        this.clip = Math.max(this.clip, this.length + Math.max(this.sizeFrom, this.sizeTo));
    }

    @Override
    public void render(Effect.EffectContainer e) {
        if (this.tex == null) {
            this.tex = Core.atlas.find(this.region);
        }
        float rawfin = e.fin();
        float fin = e.fin(this.interp);
        float rad = this.interp.apply(this.sizeFrom, this.sizeTo, rawfin) * 2.0f;
        Draw.color(this.colorFrom, this.colorTo, fin);
        if (this.line) {
            Lines.stroke(this.interp.apply(this.strokeFrom, this.strokeTo, rawfin));
            float len = this.interp.apply(this.lenFrom, this.lenTo, rawfin);
            Angles.randLenVectors(e.id, this.particles, this.length * fin + this.baseLength, e.rotation, this.cone, (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), len));
        } else {
            Angles.randLenVectors(e.id, this.particles, this.length * fin + this.baseLength, e.rotation, this.cone, (x, y) -> Draw.rect(this.tex, e.x + x, e.y + y, rad, rad, e.rotation + this.offset));
        }
    }
}

