/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.effect;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Interp;
import mindustry.entities.Effect;

public class WaveEffect
extends Effect {
    public Color colorFrom = Color.white.cpy();
    public Color colorTo = Color.white.cpy();
    public float sizeFrom = 0.0f;
    public float sizeTo = 100.0f;
    public int sides = -1;
    public float rotation = 0.0f;
    public float strokeFrom = 2.0f;
    public float strokeTo = 0.0f;
    public Interp interp = Interp.linear;

    @Override
    public void init() {
        this.clip = Math.max(this.clip, Math.max(this.sizeFrom, this.sizeTo) + Math.max(this.strokeFrom, this.strokeTo));
    }

    @Override
    public void render(Effect.EffectContainer e) {
        float fin = e.fin();
        float ifin = e.fin(this.interp);
        Draw.color(this.colorFrom, this.colorTo, ifin);
        Lines.stroke(this.interp.apply(this.strokeFrom, this.strokeTo, fin));
        float rad = this.interp.apply(this.sizeFrom, this.sizeTo, fin);
        Lines.poly(e.x, e.y, this.sides <= 0 ? Lines.circleVertices(rad) : this.sides, rad, this.rotation + e.rotation);
    }
}

