/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.units;

import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Interval;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.entities.Predict;
import mindustry.entities.Units;
import mindustry.entities.units.UnitCommand;
import mindustry.entities.units.UnitController;
import mindustry.entities.units.WeaponMount;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.type.Weapon;
import mindustry.world.Tile;
import mindustry.world.meta.BlockFlag;

public class AIController
implements UnitController {
    protected static final Vec2 vec = new Vec2();
    protected static final int timerTarget = 0;
    protected static final int timerTarget2 = 1;
    protected static final int timerTarget3 = 2;
    protected static final int timerTarget4 = 3;
    protected Unit unit;
    protected Interval timer = new Interval(4);
    protected AIController fallback;
    protected Teamc target;
    protected Teamc[] targets = new Teamc[0];

    public AIController() {
        this.timer.reset(0, Mathf.random(40.0f));
        this.timer.reset(1, Mathf.random(60.0f));
    }

    @Override
    public void updateUnit() {
        if (this.useFallback() && (this.fallback != null || (this.fallback = this.fallback()) != null)) {
            if (this.fallback.unit != this.unit) {
                this.fallback.unit(this.unit);
            }
            this.fallback.updateUnit();
            return;
        }
        this.updateVisuals();
        this.updateTargeting();
        this.updateMovement();
    }

    @Nullable
    protected AIController fallback() {
        return null;
    }

    protected boolean useFallback() {
        return false;
    }

    protected UnitCommand command() {
        return this.unit.team.data().command;
    }

    protected void updateVisuals() {
        if (this.unit.isFlying()) {
            this.unit.wobble();
            this.unit.lookAt(this.unit.prefRotation());
        }
    }

    protected void updateMovement() {
    }

    protected void updateTargeting() {
        if (this.unit.hasWeapons()) {
            this.updateWeapons();
        }
    }

    protected boolean invalid(Teamc target) {
        return Units.invalidateTarget(target, this.unit.team, this.unit.x, this.unit.y);
    }

    protected void pathfind(int pathTarget) {
        int costType = this.unit.pathType();
        Tile tile = this.unit.tileOn();
        if (tile == null) {
            return;
        }
        Tile targetTile = Vars.pathfinder.getTargetTile(tile, Vars.pathfinder.getField(this.unit.team, costType, pathTarget));
        if (tile == targetTile || costType == 2 && !targetTile.floor().isLiquid) {
            return;
        }
        this.unit.moveAt(vec.trns(this.unit.angleTo(targetTile.worldx(), targetTile.worldy()), this.unit.speed()));
    }

    protected void updateWeapons() {
        if (this.targets.length != this.unit.mounts.length) {
            this.targets = new Teamc[this.unit.mounts.length];
        }
        float rotation = this.unit.rotation - 90.0f;
        boolean ret = this.retarget();
        if (ret) {
            this.target = this.findTarget(this.unit.x, this.unit.y, this.unit.range(), this.unit.type.targetAir, this.unit.type.targetGround);
        }
        if (this.invalid(this.target)) {
            this.target = null;
        }
        this.unit.isShooting = false;
        for (int i = 0; i < this.targets.length; ++i) {
            WeaponMount mount = this.unit.mounts[i];
            Weapon weapon = mount.weapon;
            float mountX = this.unit.x + Angles.trnsx(rotation, weapon.x, weapon.y);
            float mountY = this.unit.y + Angles.trnsy(rotation, weapon.x, weapon.y);
            if (this.unit.type.singleTarget) {
                this.targets[i] = this.target;
            } else {
                if (ret) {
                    this.targets[i] = this.findTarget(mountX, mountY, weapon.bullet.range(), weapon.bullet.collidesAir, weapon.bullet.collidesGround);
                }
                if (this.checkTarget(this.targets[i], mountX, mountY, weapon.bullet.range())) {
                    this.targets[i] = null;
                }
            }
            boolean shoot = false;
            if (this.targets[i] != null) {
                shoot = this.targets[i].within(mountX, mountY, weapon.bullet.range()) && this.shouldShoot();
                Vec2 to = Predict.intercept((Position)this.unit, this.targets[i], weapon.bullet.speed);
                mount.aimX = to.x;
                mount.aimY = to.y;
            }
            mount.shoot = shoot;
            mount.rotate = shoot;
            this.unit.isShooting |= shoot;
            if (!shoot) continue;
            this.unit.aimX = mount.aimX;
            this.unit.aimY = mount.aimY;
        }
    }

    protected boolean checkTarget(Teamc target, float x, float y, float range) {
        return Units.invalidateTarget(target, this.unit.team, x, y, range);
    }

    protected boolean shouldShoot() {
        return true;
    }

    protected Teamc targetFlag(float x, float y, BlockFlag flag, boolean enemy) {
        Tile target = Geometry.findClosest(x, y, enemy ? Vars.indexer.getEnemy(this.unit.team, flag) : Vars.indexer.getAllied(this.unit.team, flag));
        return target == null ? null : target.build;
    }

    protected Teamc target(float x, float y, float range, boolean air, boolean ground) {
        return Units.closestTarget(this.unit.team, x, y, range, u -> u.checkTarget(air, ground), t -> ground);
    }

    protected boolean retarget() {
        return this.timer.get(0, this.target == null ? 40.0f : 90.0f);
    }

    protected Teamc findTarget(float x, float y, float range, boolean air, boolean ground) {
        return this.target(x, y, range, air, ground);
    }

    protected void init() {
    }

    @Nullable
    protected Tile getClosestSpawner() {
        return Geometry.findClosest(this.unit.x, this.unit.y, Vars.spawner.getSpawns());
    }

    protected void circle(Position target, float circleLength) {
        this.circle(target, circleLength, this.unit.speed());
    }

    protected void circle(Position target, float circleLength, float speed) {
        if (target == null) {
            return;
        }
        vec.set(target).sub(this.unit);
        if (vec.len() < circleLength) {
            vec.rotate((circleLength - vec.len()) / circleLength * 180.0f);
        }
        vec.setLength(speed);
        this.unit.moveAt(vec);
    }

    protected void moveTo(Position target, float circleLength) {
        this.moveTo(target, circleLength, 100.0f);
    }

    protected void moveTo(Position target, float circleLength, float smooth) {
        if (target == null) {
            return;
        }
        vec.set(target).sub(this.unit);
        float length = circleLength <= 0.001f ? 1.0f : Mathf.clamp((this.unit.dst(target) - circleLength) / smooth, -1.0f, 1.0f);
        vec.setLength(this.unit.realSpeed() * length);
        if (length < -0.5f) {
            vec.rotate(180.0f);
        } else if (length < 0.0f) {
            vec.setZero();
        }
        this.unit.moveAt(vec);
    }

    @Override
    public void unit(Unit unit) {
        if (this.unit == unit) {
            return;
        }
        this.unit = unit;
        this.init();
    }

    @Override
    public Unit unit() {
        return this.unit;
    }
}

