/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.util.Nullable;
import mindustry.core.GameState;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.units.UnitCommand;
import mindustry.game.Schematic;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.net.Host;
import mindustry.net.NetConnection;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Sector;
import mindustry.world.Tile;

public class EventType {

    public static class PlayerIpUnbanEvent {
        public final String ip;

        public PlayerIpUnbanEvent(String ip) {
            this.ip = ip;
        }
    }

    public static class PlayerIpBanEvent {
        public final String ip;

        public PlayerIpBanEvent(String ip) {
            this.ip = ip;
        }
    }

    public static class PlayerUnbanEvent {
        @Nullable
        public final Player player;
        public final String uuid;

        public PlayerUnbanEvent(Player player, String uuid) {
            this.player = player;
            this.uuid = uuid;
        }
    }

    public static class PlayerBanEvent {
        @Nullable
        public final Player player;
        public final String uuid;

        public PlayerBanEvent(Player player, String uuid) {
            this.player = player;
            this.uuid = uuid;
        }
    }

    public static class PlayerLeave {
        public final Player player;

        public PlayerLeave(Player player) {
            this.player = player;
        }
    }

    public static class PlayerConnect {
        public final Player player;

        public PlayerConnect(Player player) {
            this.player = player;
        }
    }

    public static class PlayerJoin {
        public final Player player;

        public PlayerJoin(Player player) {
            this.player = player;
        }
    }

    public static class ConnectionEvent {
        public final NetConnection connection;

        public ConnectionEvent(NetConnection connection) {
            this.connection = connection;
        }
    }

    public static class UnitChangeEvent {
        public final Player player;
        public final Unit unit;

        public UnitChangeEvent(Player player, Unit unit) {
            this.player = player;
            this.unit = unit;
        }
    }

    public static class UnitUnloadEvent {
        public final Unit unit;

        public UnitUnloadEvent(Unit unit) {
            this.unit = unit;
        }
    }

    public static class UnitCreateEvent {
        public final Unit unit;
        public final Building spawner;

        public UnitCreateEvent(Unit unit, Building spawner) {
            this.unit = unit;
            this.spawner = spawner;
        }
    }

    public static class UnitDrownEvent {
        public final Unit unit;

        public UnitDrownEvent(Unit unit) {
            this.unit = unit;
        }
    }

    public static class UnitDestroyEvent {
        public final Unit unit;

        public UnitDestroyEvent(Unit unit) {
            this.unit = unit;
        }
    }

    public static class BlockDestroyEvent {
        public final Tile tile;

        public BlockDestroyEvent(Tile tile) {
            this.tile = tile;
        }
    }

    public static class BuildSelectEvent {
        public final Tile tile;
        public final Team team;
        public final Unit builder;
        public final boolean breaking;

        public BuildSelectEvent(Tile tile, Team team, Unit builder, boolean breaking) {
            this.tile = tile;
            this.team = team;
            this.builder = builder;
            this.breaking = breaking;
        }
    }

    public static class BlockBuildEndEvent {
        public final Tile tile;
        public final Team team;
        @Nullable
        public final Unit unit;
        public final boolean breaking;
        @Nullable
        public final Object config;

        public BlockBuildEndEvent(Tile tile, @Nullable Unit unit, Team team, boolean breaking, @Nullable Object config) {
            this.tile = tile;
            this.team = team;
            this.unit = unit;
            this.breaking = breaking;
            this.config = config;
        }
    }

    public static class BlockBuildBeginEvent {
        public final Tile tile;
        public final Team team;
        @Nullable
        public final Unit unit;
        public final boolean breaking;

        public BlockBuildBeginEvent(Tile tile, Team team, Unit unit, boolean breaking) {
            this.tile = tile;
            this.team = team;
            this.unit = unit;
            this.breaking = breaking;
        }
    }

    public static class ResearchEvent {
        public final UnlockableContent content;

        public ResearchEvent(UnlockableContent content) {
            this.content = content;
        }
    }

    public static class UnlockEvent {
        public final UnlockableContent content;

        public UnlockEvent(UnlockableContent content) {
            this.content = content;
        }
    }

    public static class StateChangeEvent {
        public final GameState.State from;
        public final GameState.State to;

        public StateChangeEvent(GameState.State from, GameState.State to) {
            this.from = from;
            this.to = to;
        }
    }

    public static class TileChangeEvent {
        public final Tile tile;

        public TileChangeEvent(Tile tile) {
            this.tile = tile;
        }
    }

    public static class GameOverEvent {
        public final Team winner;

        public GameOverEvent(Team winner) {
            this.winner = winner;
        }
    }

    public static class UnitControlEvent {
        public final Player player;
        @Nullable
        public final Unit unit;

        public UnitControlEvent(Player player, @Nullable Unit unit) {
            this.player = player;
            this.unit = unit;
        }
    }

    public static class PickupEvent {
        public final Unit carrier;
        @Nullable
        public final Unit unit;
        @Nullable
        public final Building build;

        public PickupEvent(Unit carrier, Unit unit) {
            this.carrier = carrier;
            this.unit = unit;
            this.build = null;
        }

        public PickupEvent(Unit carrier, Building build) {
            this.carrier = carrier;
            this.build = build;
            this.unit = null;
        }
    }

    public static class TapEvent {
        public final Player player;
        public final Tile tile;

        public TapEvent(Player player, Tile tile) {
            this.tile = tile;
            this.player = player;
        }
    }

    public static class ConfigEvent {
        public final Building tile;
        public final Player player;
        public final Object value;

        public ConfigEvent(Building tile, Player player, Object value) {
            this.tile = tile;
            this.player = player;
            this.value = value;
        }
    }

    public static class DepositEvent {
        public final Building tile;
        public final Player player;
        public final Item item;
        public final int amount;

        public DepositEvent(Building tile, Player player, Item item, int amount) {
            this.tile = tile;
            this.player = player;
            this.item = item;
            this.amount = amount;
        }
    }

    public static class WithdrawEvent {
        public final Building tile;
        public final Player player;
        public final Item item;
        public final int amount;

        public WithdrawEvent(Building tile, Player player, Item item, int amount) {
            this.tile = tile;
            this.player = player;
            this.item = item;
            this.amount = amount;
        }
    }

    public static class SectorCaptureEvent {
        public final Sector sector;

        public SectorCaptureEvent(Sector sector) {
            this.sector = sector;
        }
    }

    public static class PlayerChatEvent {
        public final Player player;
        public final String message;

        public PlayerChatEvent(Player player, String message) {
            this.player = player;
            this.message = message;
        }
    }

    public static class ClientPreConnectEvent {
        public final Host host;

        public ClientPreConnectEvent(Host host) {
            this.host = host;
        }
    }

    public static class CommandIssueEvent {
        public final Building tile;
        public final UnitCommand command;

        public CommandIssueEvent(Building tile, UnitCommand command) {
            this.tile = tile;
            this.command = command;
        }
    }

    public static class SchematicCreateEvent {
        public final Schematic schematic;

        public SchematicCreateEvent(Schematic schematic) {
            this.schematic = schematic;
        }
    }

    public static class SectorLaunchEvent {
        public final Sector sector;

        public SectorLaunchEvent(Sector sector) {
            this.sector = sector;
        }
    }

    public static class LaunchItemEvent {
        public final ItemStack stack;

        public LaunchItemEvent(ItemStack stack) {
            this.stack = stack;
        }
    }

    public static class SectorInvasionEvent {
        public final Sector sector;

        public SectorInvasionEvent(Sector sector) {
            this.sector = sector;
        }
    }

    public static class SectorLoseEvent {
        public final Sector sector;

        public SectorLoseEvent(Sector sector) {
            this.sector = sector;
        }
    }

    public static class WorldLoadEvent {
    }

    public static class FileTreeInitEvent {
    }

    public static class ClientLoadEvent {
    }

    public static class ContentInitEvent {
    }

    public static class BlockInfoEvent {
    }

    public static class CoreItemDeliverEvent {
    }

    public static class TurretAmmoDeliverEvent {
    }

    public static class LineConfirmEvent {
    }

    public static class TurnEvent {
    }

    public static class WaveEvent {
    }

    public static class ResetEvent {
    }

    public static class PlayEvent {
    }

    public static class DisposeEvent {
    }

    public static class ServerLoadEvent {
    }

    public static class ClientCreateEvent {
    }

    public static class SaveLoadEvent {
    }

    public static class MapPublishEvent {
    }

    public static class MapMakeEvent {
    }

    public static class ResizeEvent {
    }

    public static class LoseEvent {
    }

    public static class WinEvent {
    }

    public static enum Trigger {
        shock,
        phaseDeflectHit,
        impactPower,
        thoriumReactorOverheat,
        fireExtinguish,
        acceleratorUse,
        newGame,
        tutorialComplete,
        flameAmmo,
        turretCool,
        enablePixelation,
        exclusionDeath,
        suicideBomb,
        openWiki,
        teamCoreDamage,
        socketConfigChanged,
        update,
        draw,
        preDraw,
        postDraw,
        uiDrawBegin,
        uiDrawEnd,
        universeDrawBegin,
        universeDraw,
        universeDrawEnd;

    }
}

