/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.math.Mathf;
import arc.struct.ObjectIntMap;
import mindustry.type.Item;
import mindustry.type.Sector;

public class GameStats {
    public ObjectIntMap<Item> itemsDelivered = new ObjectIntMap();
    public int enemyUnitsDestroyed;
    public int wavesLasted;
    public long timeLasted;
    public int buildingsBuilt;
    public int buildingsDeconstructed;
    public int buildingsDestroyed;

    public RankResult calculateRank(Sector sector) {
        float score = 0.0f;
        int rankIndex = Mathf.clamp((int)score, 0, Rank.all.length - 1);
        Rank rank = Rank.all[rankIndex];
        String sign = Math.abs((float)rankIndex + 0.5f - score) < 0.2f || rank.name().contains("S") ? "" : ((float)rankIndex + 0.5f < score ? "-" : "+");
        return new RankResult(rank, sign);
    }

    public static enum Rank {
        F,
        D,
        C,
        B,
        A,
        S,
        SS;

        public static final Rank[] all;

        static {
            all = Rank.values();
        }
    }

    public static class RankResult {
        public final Rank rank;
        public final String modifier;

        public RankResult(Rank rank, String modifier) {
            this.rank = rank;
            this.modifier = modifier;
        }
    }
}

