/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.Core;
import arc.func.Boolf;
import arc.func.Cons;
import mindustry.Vars;
import mindustry.game.Rules;
import mindustry.game.Team;
import mindustry.maps.Map;

public enum Gamemode {
    survival(rules -> {
        rules.waveTimer = true;
        rules.waves = true;
    }, map -> map.spawns > 0),
    sandbox(rules -> {
        rules.infiniteResources = true;
        rules.waves = true;
        rules.waveTimer = false;
    }),
    attack(rules -> {
        rules.attackMode = true;
        rules.waves = true;
        rules.waveTimer = true;
        rules.waveSpacing /= 2.0f;
        rules.teams.get((Team)rules.waveTeam).infiniteResources = true;
    }, map -> map.teams.contains(Vars.state.rules.waveTeam.id)),
    pvp(rules -> {
        rules.pvp = true;
        rules.enemyCoreBuildRadius = 600.0f;
        rules.buildCostMultiplier = 1.0f;
        rules.buildSpeedMultiplier = 1.0f;
        rules.unitBuildSpeedMultiplier = 2.0f;
        rules.attackMode = true;
    }, map -> map.teams.size > 1),
    editor(true, rules -> {
        rules.infiniteResources = true;
        rules.editor = true;
        rules.waves = false;
        rules.enemyCoreBuildRadius = 0.0f;
        rules.waveTimer = false;
    });

    private final Cons<Rules> rules;
    private final Boolf<Map> validator;
    public final boolean hidden;
    public static final Gamemode[] all;

    private Gamemode(Cons<Rules> rules) {
        this(false, rules);
    }

    private Gamemode(boolean hidden, Cons<Rules> rules) {
        this(hidden, rules, m -> true);
    }

    private Gamemode(Cons<Rules> rules, Boolf<Map> validator) {
        this(false, rules, validator);
    }

    private Gamemode(boolean hidden, Cons<Rules> rules, Boolf<Map> validator) {
        this.rules = rules;
        this.hidden = hidden;
        this.validator = validator;
    }

    public Rules apply(Rules in) {
        this.rules.get(in);
        return in;
    }

    public boolean valid(Map map) {
        return this.validator.get(map);
    }

    public String description() {
        return Core.bundle.get("mode." + this.name() + ".description");
    }

    public String toString() {
        return Core.bundle.get("mode." + this.name() + ".name");
    }

    static {
        all = Gamemode.values();
    }
}

