/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.Core;
import arc.scene.ui.layout.Table;
import mindustry.ctype.UnlockableContent;
import mindustry.type.SectorPreset;

public class Objectives {

    public static interface Objective {
        public boolean complete();

        public String display();

        default public void build(Table table) {
        }
    }

    public static class SectorComplete
    implements Objective {
        public SectorPreset preset;

        public SectorComplete(SectorPreset zone) {
            this.preset = zone;
        }

        protected SectorComplete() {
        }

        @Override
        public boolean complete() {
            return this.preset.sector.save != null && (!this.preset.sector.isAttacked() || this.preset.sector.info.wasCaptured) && this.preset.sector.hasBase();
        }

        @Override
        public String display() {
            return Core.bundle.format("requirement.capture", this.preset.localizedName);
        }
    }

    public static class Produce
    implements Objective {
        public UnlockableContent content;

        public Produce(UnlockableContent content) {
            this.content = content;
        }

        protected Produce() {
        }

        @Override
        public boolean complete() {
            return this.content.unlocked();
        }

        @Override
        public String display() {
            return Core.bundle.format("requirement.produce", this.content.emoji() + " " + this.content.localizedName);
        }
    }

    public static class Research
    implements Objective {
        public UnlockableContent content;

        public Research(UnlockableContent content) {
            this.content = content;
        }

        protected Research() {
        }

        @Override
        public boolean complete() {
            return this.content.unlocked();
        }

        @Override
        public String display() {
            return Core.bundle.format("requirement.research", this.content.emoji() + " " + this.content.localizedName);
        }
    }
}

