/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.graphics.Color;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Nullable;
import arc.util.serialization.Json;
import arc.util.serialization.JsonValue;
import mindustry.content.Items;
import mindustry.game.Gamemode;
import mindustry.game.SpawnGroup;
import mindustry.game.Team;
import mindustry.io.JsonIO;
import mindustry.type.ItemStack;
import mindustry.type.Sector;
import mindustry.type.Weather;
import mindustry.world.Block;

public class Rules {
    public boolean infiniteResources;
    public TeamRules teams = new TeamRules();
    public boolean waveTimer = true;
    public boolean waves;
    public boolean pvp;
    public boolean waitEnemies = false;
    public boolean attackMode = false;
    public boolean editor = false;
    public boolean canGameOver = true;
    public boolean reactorExplosions = true;
    public boolean schematicsAllowed = true;
    public boolean damageExplosions = true;
    public boolean fire = true;
    public boolean unitAmmo = false;
    public boolean unitCapVariable = true;
    public float unitBuildSpeedMultiplier = 1.0f;
    public float unitDamageMultiplier = 1.0f;
    public boolean logicUnitBuild = true;
    public float blockHealthMultiplier = 1.0f;
    public float blockDamageMultiplier = 1.0f;
    public float buildCostMultiplier = 1.0f;
    public float buildSpeedMultiplier = 1.0f;
    public float deconstructRefundMultiplier = 0.5f;
    public float enemyCoreBuildRadius = 400.0f;
    public float dropZoneRadius = 300.0f;
    public float waveSpacing = 7200.0f;
    public int winWave = 0;
    public int unitCap = 0;
    @Nullable
    public Sector sector;
    public Seq<SpawnGroup> spawns = new Seq();
    public Seq<ItemStack> loadout = ItemStack.list(Items.copper, 100);
    public Seq<Weather.WeatherEntry> weather = new Seq(1);
    public ObjectSet<Block> bannedBlocks = new ObjectSet();
    public ObjectSet<Block> revealedBlocks = new ObjectSet();
    public ObjectSet<String> researched = new ObjectSet();
    public boolean lighting = false;
    public boolean enemyLights = true;
    public Color ambientLight = new Color(0.01f, 0.01f, 0.04f, 0.99f);
    public Team defaultTeam = Team.sharded;
    public Team waveTeam = Team.crux;
    @Nullable
    public String modeName;
    public boolean coreIncinerates = false;
    public StringMap tags = new StringMap();

    public Rules copy() {
        return JsonIO.copy(this);
    }

    public Gamemode mode() {
        if (this.pvp) {
            return Gamemode.pvp;
        }
        if (this.editor) {
            return Gamemode.editor;
        }
        if (this.attackMode) {
            return Gamemode.attack;
        }
        if (this.infiniteResources) {
            return Gamemode.sandbox;
        }
        return Gamemode.survival;
    }

    public static class TeamRules
    implements Json.JsonSerializable {
        final TeamRule[] values = new TeamRule[Team.all.length];

        public TeamRule get(Team team) {
            TeamRule out = this.values[team.id];
            if (out == null) {
                this.values[team.id] = out = new TeamRule();
            }
            return out;
        }

        @Override
        public void write(Json json) {
            for (Team team : Team.all) {
                if (this.values[team.id] == null) continue;
                json.writeValue(team.id + "", this.values[team.id], TeamRule.class);
            }
        }

        @Override
        public void read(Json json, JsonValue jsonData) {
            for (JsonValue value : jsonData) {
                this.values[Integer.parseInt((String)value.name)] = json.readValue(TeamRule.class, value);
            }
        }
    }

    public static class TeamRule {
        public boolean ai;
        public float aiTier = 1.0f;
        public boolean aiCoreSpawn = true;
        public boolean cheat;
        public boolean infiniteResources;
        public boolean infiniteAmmo;
    }
}

