/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.Core;
import arc.Events;
import arc.assets.AssetDescriptor;
import arc.files.Fi;
import arc.graphics.Texture;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.async.AsyncExecutor;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import mindustry.Vars;
import mindustry.core.GameState;
import mindustry.game.EventType;
import mindustry.game.Gamemode;
import mindustry.io.SaveIO;
import mindustry.io.SaveMeta;
import mindustry.io.SavePreviewLoader;
import mindustry.maps.Map;
import mindustry.type.Sector;

public class Saves {
    Seq<SaveSlot> saves = new Seq();
    @Nullable
    SaveSlot current;
    @Nullable
    private SaveSlot lastSectorSave;
    AsyncExecutor previewExecutor = new AsyncExecutor(1);
    private boolean saving;
    private float time;
    long totalPlaytime;
    private long lastTimestamp;

    public Saves() {
        Core.assets.setLoader(Texture.class, ".spreview", new SavePreviewLoader());
        Events.on(EventType.StateChangeEvent.class, event -> {
            if (event.to == GameState.State.menu) {
                this.totalPlaytime = 0L;
                this.lastTimestamp = 0L;
                this.current = null;
            }
        });
    }

    public void load() {
        this.saves.clear();
        for (Fi file : Vars.saveDirectory.list()) {
            if (file.name().contains("backup") || !SaveIO.isSaveValid(file)) continue;
            SaveSlot slot = new SaveSlot(file);
            this.saves.add(slot);
            slot.meta = SaveIO.getMeta(file);
        }
        this.lastSectorSave = this.saves.find(s -> s.isSector() && s.getName().equals(Core.settings.getString("last-sector-save", "<none>")));
        for (SaveSlot slot : this.saves) {
            if (slot.getSector() == null) continue;
            if (slot.getSector().save != null) {
                Log.warn("Sector @ has two corresponding saves: @ and @", slot.getSector(), slot.getSector().save.file, slot.file);
            }
            slot.getSector().save = slot;
        }
    }

    @Nullable
    public SaveSlot getLastSector() {
        return this.lastSectorSave;
    }

    @Nullable
    public SaveSlot getCurrent() {
        return this.current;
    }

    public void update() {
        if (!(this.current == null || !Vars.state.isGame() || Vars.state.isPaused() && Core.scene.hasDialog())) {
            if (this.lastTimestamp != 0L) {
                this.totalPlaytime += Time.timeSinceMillis(this.lastTimestamp);
            }
            this.lastTimestamp = Time.millis();
        }
        if (Vars.state.isGame() && !Vars.state.gameOver && this.current != null && this.current.isAutosave()) {
            this.time += Time.delta;
            if (this.time > (float)(Core.settings.getInt("saveinterval") * 60)) {
                this.saving = true;
                try {
                    this.current.save();
                }
                catch (Throwable t) {
                    Log.err(t);
                }
                Time.runTask(3.0f, () -> {
                    this.saving = false;
                });
                this.time = 0.0f;
            }
        } else {
            this.time = 0.0f;
        }
    }

    public long getTotalPlaytime() {
        return this.totalPlaytime;
    }

    public void resetSave() {
        this.current = null;
    }

    public boolean isSaving() {
        return this.saving;
    }

    public Fi getSectorFile(Sector sector) {
        return Vars.saveDirectory.child("sector-" + sector.planet.name + "-" + sector.id + "." + "msav");
    }

    public void saveSector(Sector sector) {
        if (sector.save == null) {
            sector.save = new SaveSlot(this.getSectorFile(sector));
            sector.save.setName(sector.save.file.nameWithoutExtension());
            this.saves.add(sector.save);
        }
        sector.save.setAutosave(true);
        sector.save.save();
        this.lastSectorSave = sector.save;
        Core.settings.put("last-sector-save", sector.save.getName());
    }

    public SaveSlot addSave(String name) {
        SaveSlot slot = new SaveSlot(this.getNextSlotFile());
        slot.setName(name);
        this.saves.add(slot);
        slot.save();
        return slot;
    }

    public SaveSlot importSave(Fi file) throws IOException {
        SaveSlot slot = new SaveSlot(this.getNextSlotFile());
        slot.importFile(file);
        slot.setName(file.nameWithoutExtension());
        this.saves.add(slot);
        slot.meta = SaveIO.getMeta(slot.file);
        this.current = slot;
        return slot;
    }

    public Fi getNextSlotFile() {
        Fi file;
        int i = 0;
        while ((file = Vars.saveDirectory.child(i + "." + "msav")).exists()) {
            ++i;
        }
        return file;
    }

    public Seq<SaveSlot> getSaveSlots() {
        return this.saves;
    }

    public void deleteAll() {
        for (SaveSlot slot : this.saves.copy()) {
            if (slot.isSector()) continue;
            slot.delete();
        }
    }

    public class SaveSlot {
        public final Fi file;
        boolean requestedPreview;
        public SaveMeta meta;

        public SaveSlot(Fi file) {
            this.file = file;
        }

        public void load() throws SaveIO.SaveException {
            try {
                SaveIO.load(this.file);
                this.meta = SaveIO.getMeta(this.file);
                Saves.this.current = this;
                Saves.this.totalPlaytime = this.meta.timePlayed;
                this.savePreview();
            }
            catch (Throwable e) {
                throw new SaveIO.SaveException(e);
            }
        }

        public void save() {
            long time = Saves.this.totalPlaytime;
            long prev = Saves.this.totalPlaytime;
            Saves.this.totalPlaytime = time;
            SaveIO.save(this.file);
            this.meta = SaveIO.getMeta(this.file);
            if (Vars.state.isGame()) {
                Saves.this.current = this;
            }
            Saves.this.totalPlaytime = prev;
            this.savePreview();
        }

        private void savePreview() {
            if (Core.assets.isLoaded(this.loadPreviewFile().path())) {
                Core.assets.unload(this.loadPreviewFile().path());
            }
            Saves.this.previewExecutor.submit(() -> {
                try {
                    this.previewFile().writePNG(Vars.renderer.minimap.getPixmap());
                    this.requestedPreview = false;
                }
                catch (Throwable t) {
                    Log.err(t);
                }
            });
        }

        public Texture previewTexture() {
            if (!this.previewFile().exists()) {
                return null;
            }
            if (Core.assets.isLoaded(this.loadPreviewFile().path())) {
                return (Texture)Core.assets.get(this.loadPreviewFile().path());
            }
            if (!this.requestedPreview) {
                Core.assets.load(new AssetDescriptor<Texture>(this.loadPreviewFile(), Texture.class));
                this.requestedPreview = true;
            }
            return null;
        }

        private String index() {
            return this.file.nameWithoutExtension();
        }

        private Fi previewFile() {
            return Vars.mapPreviewDirectory.child("save_slot_" + this.index() + ".png");
        }

        private Fi loadPreviewFile() {
            return this.previewFile().sibling(this.previewFile().name() + ".spreview");
        }

        public boolean isHidden() {
            return this.isSector();
        }

        public String getPlayTime() {
            return Strings.formatMillis(Saves.this.current == this ? Saves.this.totalPlaytime : this.meta.timePlayed);
        }

        public long getTimestamp() {
            return this.meta.timestamp;
        }

        public String getDate() {
            return SimpleDateFormat.getDateTimeInstance().format(new Date(this.meta.timestamp));
        }

        public Map getMap() {
            return this.meta.map;
        }

        public void cautiousLoad(Runnable run) {
            Seq<String> mods = Seq.with(this.getMods());
            mods.removeAll(Vars.mods.getModStrings());
            if (!mods.isEmpty()) {
                Vars.ui.showConfirm("@warning", Core.bundle.format("mod.missing", mods.toString("\n")), run);
            } else {
                run.run();
            }
        }

        public String getName() {
            return Core.settings.getString("save-" + this.index() + "-name", "untitled");
        }

        public void setName(String name) {
            Core.settings.put("save-" + this.index() + "-name", name);
        }

        public String[] getMods() {
            return this.meta.mods;
        }

        public Sector getSector() {
            return this.meta == null || this.meta.rules == null ? null : this.meta.rules.sector;
        }

        public boolean isSector() {
            return this.getSector() != null;
        }

        public Gamemode mode() {
            return this.meta.rules.mode();
        }

        public int getBuild() {
            return this.meta.build;
        }

        public int getWave() {
            return this.meta.wave;
        }

        public boolean isAutosave() {
            return Core.settings.getBool("save-" + this.index() + "-autosave", true);
        }

        public void setAutosave(boolean save) {
            Core.settings.put("save-" + this.index() + "-autosave", save);
        }

        public void importFile(Fi from) throws IOException {
            try {
                from.copyTo(this.file);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public void exportFile(Fi to) throws IOException {
            try {
                this.file.copyTo(to);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public void delete() {
            if (SaveIO.backupFileFor(this.file).exists()) {
                SaveIO.backupFileFor(this.file).delete();
            }
            this.file.delete();
            Saves.this.saves.remove(this, true);
            if (this == Saves.this.current) {
                Saves.this.current = null;
            }
            if (Core.assets.isLoaded(this.loadPreviewFile().path())) {
                Core.assets.unload(this.loadPreviewFile().path());
            }
        }
    }
}

