/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.util.Nullable;
import arc.util.Structs;
import arc.util.serialization.Json;
import arc.util.serialization.JsonValue;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.content.UnitTypes;
import mindustry.ctype.ContentType;
import mindustry.game.Team;
import mindustry.gen.Unit;
import mindustry.io.legacy.LegacyIO;
import mindustry.type.ItemStack;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;

public class SpawnGroup
implements Json.JsonSerializable {
    public static final int never = Integer.MAX_VALUE;
    public UnitType type = UnitTypes.dagger;
    public int end = Integer.MAX_VALUE;
    public int begin;
    public int spacing = 1;
    public int max = 40;
    public float unitScaling = 2.1474836E9f;
    public float shields = 0.0f;
    public float shieldScaling = 0.0f;
    public int unitAmount = 1;
    @Nullable
    public StatusEffect effect;
    @Nullable
    public ItemStack items;

    public SpawnGroup(UnitType type) {
        this.type = type;
    }

    public SpawnGroup() {
    }

    public int getSpawned(int wave) {
        if (this.spacing == 0) {
            this.spacing = 1;
        }
        if (wave < this.begin || wave > this.end || (wave - this.begin) % this.spacing != 0) {
            return 0;
        }
        return Math.min(this.unitAmount + (int)((float)((wave - this.begin) / this.spacing) / this.unitScaling), this.max);
    }

    public float getShield(int wave) {
        return Math.max(this.shields + this.shieldScaling * (float)(wave - this.begin), 0.0f);
    }

    public Unit createUnit(Team team, int wave) {
        Unit unit = this.type.create(team);
        if (this.effect != null) {
            unit.apply(this.effect, 999999.0f);
        }
        if (this.items != null) {
            unit.addItem(this.items.item, this.items.amount);
        }
        unit.shield = this.getShield(wave);
        return unit;
    }

    @Override
    public void write(Json json) {
        if (this.type == null) {
            this.type = UnitTypes.dagger;
        }
        json.writeValue("type", this.type.name);
        if (this.begin != 0) {
            json.writeValue("begin", this.begin);
        }
        if (this.end != Integer.MAX_VALUE) {
            json.writeValue("end", this.end);
        }
        if (this.spacing != 1) {
            json.writeValue("spacing", this.spacing);
        }
        if (this.max != 40) {
            json.writeValue("max", this.max);
        }
        if (this.unitScaling != 2.1474836E9f) {
            json.writeValue("scaling", Float.valueOf(this.unitScaling));
        }
        if (this.shields != 0.0f) {
            json.writeValue("shields", Float.valueOf(this.shields));
        }
        if (this.shieldScaling != 0.0f) {
            json.writeValue("shieldScaling", Float.valueOf(this.shieldScaling));
        }
        if (this.unitAmount != 1) {
            json.writeValue("amount", this.unitAmount);
        }
        if (this.effect != null) {
            json.writeValue("effect", this.effect.name);
        }
    }

    @Override
    public void read(Json json, JsonValue data) {
        String tname = data.getString("type", "dagger");
        this.type = (UnitType)Vars.content.getByName(ContentType.unit, LegacyIO.unitMap.get(tname, tname));
        if (this.type == null) {
            this.type = UnitTypes.dagger;
        }
        this.begin = data.getInt("begin", 0);
        this.end = data.getInt("end", Integer.MAX_VALUE);
        this.spacing = data.getInt("spacing", 1);
        this.max = data.getInt("max", 40);
        this.unitScaling = data.getFloat("scaling", 2.1474836E9f);
        this.shields = data.getFloat("shields", 0.0f);
        this.shieldScaling = data.getFloat("shieldScaling", 0.0f);
        this.unitAmount = data.getInt("amount", 1);
        this.effect = data.has("effect") && data.get("effect").isNumber() && data.getInt("effect", -1) == 8 ? StatusEffects.boss : (StatusEffect)Vars.content.getByName(ContentType.status, data.has("effect") && data.get("effect").isString() ? data.getString("effect", "none") : "none");
    }

    public String toString() {
        return "SpawnGroup{type=" + this.type + ", end=" + this.end + ", begin=" + this.begin + ", spacing=" + this.spacing + ", max=" + this.max + ", unitScaling=" + this.unitScaling + ", unitAmount=" + this.unitAmount + ", effect=" + this.effect + ", items=" + this.items + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpawnGroup group = (SpawnGroup)o;
        return this.end == group.end && this.begin == group.begin && this.spacing == group.spacing && this.max == group.max && Float.compare(group.unitScaling, this.unitScaling) == 0 && Float.compare(group.shields, this.shields) == 0 && Float.compare(group.shieldScaling, this.shieldScaling) == 0 && this.unitAmount == group.unitAmount && this.type == group.type && this.effect == group.effect && Structs.eq(this.items, group.items);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.type, this.end, this.begin, this.spacing, this.max, Float.valueOf(this.unitScaling), Float.valueOf(this.shields), Float.valueOf(this.shieldScaling), this.unitAmount, this.effect, this.items});
    }
}

