/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.func.Boolf;
import arc.func.Cons;
import arc.math.geom.Geometry;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import arc.struct.Queue;
import arc.struct.Seq;
import arc.util.Nullable;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.ai.BaseAI;
import mindustry.content.Items;
import mindustry.entities.units.UnitCommand;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Payloadc;
import mindustry.gen.Unit;
import mindustry.type.Item;
import mindustry.type.UnitType;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.blocks.storage.CoreBlock;

public class Teams {
    private TeamData[] map = new TeamData[256];
    public Seq<TeamData> active = new Seq();
    public Seq<TeamData> present = new Seq(TeamData.class);
    @Nullable
    public Unit boss;

    public Teams() {
        this.active.add(this.get(Team.crux));
    }

    @Nullable
    public CoreBlock.CoreBuild closestEnemyCore(float x, float y, Team team) {
        for (Team enemy : team.data().coreEnemies) {
            CoreBlock.CoreBuild tile = Geometry.findClosest(x, y, enemy.cores());
            if (tile == null) continue;
            return tile;
        }
        return null;
    }

    @Nullable
    public CoreBlock.CoreBuild closestCore(float x, float y, Team team) {
        return Geometry.findClosest(x, y, this.get((Team)team).cores);
    }

    public boolean eachEnemyCore(Team team, Boolf<CoreBlock.CoreBuild> ret) {
        for (TeamData data : this.active) {
            if (!this.areEnemies(team, data.team)) continue;
            for (CoreBlock.CoreBuild tile : data.cores) {
                if (!ret.get(tile)) continue;
                return true;
            }
        }
        return false;
    }

    public void eachEnemyCore(Team team, Cons<Building> ret) {
        for (TeamData data : this.active) {
            if (!this.areEnemies(team, data.team)) continue;
            for (Building building : data.cores) {
                ret.get(building);
            }
        }
    }

    public TeamData get(Team team) {
        if (this.map[team.id] == null) {
            this.map[team.id] = new TeamData(team);
        }
        return this.map[team.id];
    }

    public Seq<CoreBlock.CoreBuild> playerCores() {
        return this.get((Team)Vars.state.rules.defaultTeam).cores;
    }

    public Seq<CoreBlock.CoreBuild> cores(Team team) {
        return this.get((Team)team).cores;
    }

    public boolean isActive(Team team) {
        return this.get(team).active();
    }

    public boolean areEnemies(Team team, Team other) {
        return team != other;
    }

    public boolean canInteract(Team team, Team other) {
        return team == other || other == Team.derelict;
    }

    public Seq<TeamData> getActive() {
        this.active.removeAll(t -> !t.active());
        return this.active;
    }

    public void registerCore(CoreBlock.CoreBuild core) {
        TeamData data = this.get(core.team);
        if (!data.cores.contains(core)) {
            data.cores.add(core);
        }
        if (data.active() && !this.active.contains(data)) {
            this.active.add(data);
            this.updateEnemies();
            Vars.indexer.updateTeamIndex(data.team);
        }
    }

    public void unregisterCore(CoreBlock.CoreBuild entity) {
        TeamData data = this.get(entity.team);
        data.cores.remove(entity);
        if (!data.active()) {
            this.active.remove(data);
            this.updateEnemies();
        }
    }

    private void count(Unit unit) {
        Payloadc payloadc;
        unit.team.data().updateCount(unit.type, 1);
        Unit unit2 = unit;
        if (unit2 instanceof Payloadc && (payloadc = (Payloadc)((Object)unit2)) == (Payloadc)((Object)unit2)) {
            payloadc.payloads().each(p -> {
                UnitPayload payload;
                Payload payload$temp = p;
                if (payload$temp instanceof UnitPayload && (payload = (UnitPayload)payload$temp) == (UnitPayload)payload$temp) {
                    this.count(payload.unit);
                }
            });
        }
    }

    public void updateTeamStats() {
        TeamData data;
        this.present.clear();
        this.boss = null;
        for (Team team : Team.all) {
            data = team.data();
            data.presentFlag = false;
            data.unitCount = 0;
            data.units.clear();
            if (data.tree != null) {
                data.tree.clear();
            }
            if (data.typeCounts != null) {
                Arrays.fill(data.typeCounts, 0);
            }
            if (data.unitsByType == null) continue;
            for (int i = 0; i < data.unitsByType.length; ++i) {
                if (data.unitsByType[i] == null) continue;
                data.unitsByType[i].clear();
            }
        }
        Groups.build.each(b -> b.team.data().presentFlag = true);
        for (Unit unit : Groups.unit) {
            TeamData data2 = unit.team.data();
            data2.tree().insert(unit);
            data2.units.add(unit);
            data2.presentFlag = true;
            if (unit.team == Vars.state.rules.waveTeam && unit.isBoss()) {
                this.boss = unit;
            }
            if (data2.unitsByType == null || data2.unitsByType.length <= unit.type.id) {
                data2.unitsByType = new Seq[Vars.content.units().size];
            }
            if (data2.unitsByType[unit.type.id] == null) {
                data2.unitsByType[unit.type.id] = new Seq();
            }
            data2.unitsByType[unit.type.id].add(unit);
            this.count(unit);
        }
        for (Team team : Team.all) {
            data = team.data();
            if (!data.presentFlag && !data.active()) continue;
            this.present.add(data);
        }
    }

    private void updateEnemies() {
        if (Vars.state.rules.waves && !this.active.contains(this.get(Vars.state.rules.waveTeam))) {
            this.active.add(this.get(Vars.state.rules.waveTeam));
        }
        for (TeamData data : this.active) {
            Seq<Team> enemies = new Seq<Team>();
            for (TeamData other : this.active) {
                if (!this.areEnemies(data.team, other.team)) continue;
                enemies.add(other.team);
            }
            data.coreEnemies = (Team[])enemies.toArray(Team.class);
        }
    }

    public static class TeamData {
        public final Seq<CoreBlock.CoreBuild> cores = new Seq();
        public final Team team;
        public final BaseAI ai;
        private boolean presentFlag;
        public Team[] coreEnemies = new Team[0];
        public Queue<BlockPlan> blocks = new Queue();
        public UnitCommand command = UnitCommand.attack;
        public Seq<Item> mineItems = Seq.with(Items.copper, Items.lead, Items.titanium, Items.thorium);
        public int unitCount;
        @Nullable
        public int[] typeCounts;
        @Nullable
        public QuadTree<Unit> tree;
        public Seq<Unit> units = new Seq();
        @Nullable
        public Seq<Unit>[] unitsByType;

        public TeamData(Team team) {
            this.team = team;
            this.ai = new BaseAI(this);
        }

        @Nullable
        public Seq<Unit> unitCache(UnitType type) {
            if (this.unitsByType == null || this.unitsByType.length <= type.id || this.unitsByType[type.id] == null) {
                return null;
            }
            return this.unitsByType[type.id];
        }

        public void updateCount(UnitType type, int amount) {
            if (type == null) {
                return;
            }
            this.unitCount = Math.max(amount + this.unitCount, 0);
            if (this.typeCounts == null || this.typeCounts.length <= type.id) {
                this.typeCounts = new int[Vars.content.units().size];
            }
            this.typeCounts[type.id] = Math.max(amount + this.typeCounts[type.id], 0);
        }

        public QuadTree<Unit> tree() {
            if (this.tree == null) {
                this.tree = new QuadTree(Vars.world.getQuadBounds(new Rect()));
            }
            return this.tree;
        }

        public int countType(UnitType type) {
            return this.typeCounts == null || this.typeCounts.length <= type.id ? 0 : this.typeCounts[type.id];
        }

        public boolean active() {
            return this.team == Vars.state.rules.waveTeam && Vars.state.rules.waves || this.cores.size > 0;
        }

        public boolean hasCore() {
            return this.cores.size > 0;
        }

        public boolean noCores() {
            return this.cores.isEmpty();
        }

        @Nullable
        public CoreBlock.CoreBuild core() {
            return this.cores.isEmpty() ? null : this.cores.first();
        }

        public boolean hasAI() {
            return this.team.rules().ai;
        }

        public String toString() {
            return "TeamData{cores=" + this.cores + ", team=" + this.team + '}';
        }
    }

    public static class BlockPlan {
        public final short x;
        public final short y;
        public final short rotation;
        public final short block;
        public final Object config;

        public BlockPlan(int x, int y, short rotation, short block, Object config) {
            this.x = (short)x;
            this.y = (short)y;
            this.rotation = rotation;
            this.block = block;
            this.config = config;
        }
    }
}

