/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.Core;
import arc.Events;
import arc.func.Prov;
import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import java.lang.invoke.LambdaMetafactory;
import mindustry.Vars;
import mindustry.content.Loadouts;
import mindustry.content.Planets;
import mindustry.game.EventType;
import mindustry.game.Schematic;
import mindustry.game.SectorInfo;
import mindustry.maps.SectorDamage;
import mindustry.type.Item;
import mindustry.type.ItemSeq;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.world.blocks.storage.CoreBlock;

public class Universe {
    private int seconds;
    private int netSeconds;
    private float secondCounter;
    private int turn;
    private float turnCounter;
    @Nullable
    private Schematic lastLoadout;
    private ItemSeq lastLaunchResources = new ItemSeq();

    public Universe() {
        this.load();
        Events.on(EventType.SectorCaptureEvent.class, e -> {
            if (!Vars.net.client() && Vars.state.isCampaign()) {
                Vars.state.getSector().planet.updateBaseCoverage();
            }
        });
    }

    public void updateGlobal() {
        this.updatePlanet(Planets.sun);
    }

    public int turn() {
        return this.turn;
    }

    private void updatePlanet(Planet planet) {
        planet.position.setZero();
        planet.addParentOffset(planet.position);
        if (planet.parent != null) {
            planet.position.add(planet.parent.position);
        }
        for (Planet child : planet.children) {
            this.updatePlanet(child);
        }
    }

    public void update() {
        if (!Vars.net.client()) {
            this.secondCounter += Time.delta / 60.0f;
            this.turnCounter += Time.delta;
            if (this.turnCounter >= 7200.0f) {
                this.turnCounter = 0.0f;
                this.runTurn();
            }
            if (this.secondCounter >= 1.0f) {
                this.seconds += (int)this.secondCounter;
                this.secondCounter %= 1.0f;
                if (this.seconds % 10 == 1) {
                    this.save();
                }
            }
        }
        if (Vars.state.hasSector()) {
            float light = Vars.state.getSector().getLight();
            float alpha = Mathf.clamp(Mathf.map(light, 0.0f, 0.8f, 0.3f, 1.0f));
            Vars.state.rules.ambientLight.a = 1.0f - alpha;
            Vars.state.rules.lighting = !Mathf.equal(alpha, 1.0f);
        }
    }

    public void clearLoadoutInfo() {
        this.lastLoadout = null;
        this.lastLaunchResources = new ItemSeq();
        Core.settings.remove("launch-resources-seq");
        Core.settings.remove("lastloadout-core-shard");
        Core.settings.remove("lastloadout-core-nucleus");
        Core.settings.remove("lastloadout-core-foundation");
    }

    public ItemSeq getLaunchResources() {
        this.lastLaunchResources = Core.settings.getJson("launch-resources-seq", ItemSeq.class, ItemSeq::new);
        return this.lastLaunchResources;
    }

    public void updateLaunchResources(ItemSeq stacks) {
        this.lastLaunchResources = stacks;
        Core.settings.putJson("launch-resources-seq", this.lastLaunchResources);
    }

    public void updateLoadout(CoreBlock block, Schematic schem) {
        Core.settings.put("lastloadout-" + block.name, schem.file == null ? "" : schem.file.nameWithoutExtension());
        this.lastLoadout = schem;
    }

    public Schematic getLastLoadout() {
        if (this.lastLoadout == null) {
            this.lastLoadout = Loadouts.basicShard;
        }
        return this.lastLoadout;
    }

    @Nullable
    public Schematic getLoadout(CoreBlock core) {
        if (Vars.schematics == null) {
            return Loadouts.basicShard;
        }
        String file = Core.settings.getString("lastloadout-" + core.name, "");
        Seq<Schematic> all = Vars.schematics.getLoadouts(core);
        Schematic schem = all.find(s -> s.file != null && s.file.nameWithoutExtension().equals(file));
        return schem == null ? (all.any() ? all.first() : null) : schem;
    }

    public void runTurn() {
        ++this.turn;
        int newSecondsPassed = 120;
        for (Planet planet : Vars.content.planets()) {
            for (Sector sector : planet.sectors) {
                int count;
                if (!sector.hasSave() || !sector.hasBase()) continue;
                sector.info.minutesCaptured = sector.isAttacked() ? 0.0f : (sector.info.minutesCaptured += 2.0f);
                if (!sector.isBeingPlayed()) {
                    Sector to;
                    if (sector.isAttacked()) {
                        sector.info.secondsPassed += 120.0f;
                    }
                    int wavesPassed = (int)(sector.info.secondsPassed * 60.0f / sector.info.waveSpacing);
                    boolean attacked = sector.info.waves;
                    if (attacked) {
                        sector.info.wavesPassed = wavesPassed;
                    }
                    float damage = attacked ? SectorDamage.getDamage(sector.info) : 0.0f;
                    sector.info.damage = Math.max(sector.info.damage, damage);
                    if (attacked && damage >= 0.999f) {
                        Events.fire(new EventType.SectorLoseEvent(sector));
                        sector.info.items.clear();
                        sector.info.damage = 1.0f;
                        sector.info.hasCore = false;
                        sector.info.production.clear();
                    } else if (attacked && wavesPassed > 0 && sector.info.winWave > 1 && sector.info.wave + wavesPassed >= sector.info.winWave && !sector.hasEnemyBase()) {
                        sector.info.waves = false;
                        sector.info.wasCaptured = true;
                        Events.fire(new EventType.SectorCaptureEvent(sector));
                    }
                    float scl = sector.getProductionScale();
                    if (sector.info.destination != null && (to = sector.info.destination).hasBase()) {
                        ItemSeq items = new ItemSeq();
                        sector.info.export.each((item, stat) -> items.add((Item)item, (int)(stat.mean * (float)newSecondsPassed * scl)));
                        to.addItems(items);
                    }
                    sector.info.export.each((item, amount) -> {
                        if (sector.info.items.get((Item)item) <= 0 && ((SectorInfo.ExportStat)((Object)sector.info.production.get((Item)item, (Prov<SectorInfo.ExportStat>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Lmindustry/game/SectorInfo$ExportStat;)()))).mean < 0.0f) {
                            sector.info.export.get((Item)item).mean = 0.0f;
                        }
                    });
                    sector.info.production.each((item, stat) -> sector.info.items.add((Item)item, Math.min((int)(stat.mean * (float)newSecondsPassed * scl), sector.info.storageCapacity - sector.info.items.get((Item)item))));
                    sector.info.items.checkNegative();
                    sector.saveInfo();
                }
                if (sector.isAttacked() || !(sector.info.minutesCaptured > 20.0f) || !sector.info.hasSpawns || (count = sector.near().count(Sector::hasEnemyBase)) <= 0 || !Mathf.chance(0.01f * (0.8f + (float)(count - 1) * 0.3f))) continue;
                int waveMax = Math.max(sector.info.winWave, sector.isBeingPlayed() ? Vars.state.wave : sector.info.wave + sector.info.wavesPassed) + Mathf.random(2, 4) * 5;
                if (sector.isBeingPlayed()) {
                    Vars.state.rules.winWave = waveMax;
                    Vars.state.rules.waves = true;
                    Vars.state.rules.attackMode = false;
                } else {
                    sector.info.winWave = waveMax;
                    sector.info.waves = true;
                    sector.info.attack = false;
                    sector.saveInfo();
                }
                Events.fire(new EventType.SectorInvasionEvent(sector));
            }
        }
        Events.fire(new EventType.TurnEvent());
        this.save();
    }

    public ItemSeq getGlobalResources() {
        ItemSeq count = new ItemSeq();
        for (Planet planet : Vars.content.planets()) {
            for (Sector sector : planet.sectors) {
                if (!sector.hasSave()) continue;
                count.add(sector.items());
            }
        }
        return count;
    }

    public void updateNetSeconds(int value) {
        this.netSeconds = value;
    }

    public float secondsMod(float mod, float scale) {
        return (float)this.seconds() / scale % mod;
    }

    public int seconds() {
        return Vars.net.client() ? this.netSeconds : this.seconds;
    }

    public float secondsf() {
        return (float)this.seconds() + this.secondCounter;
    }

    private void save() {
        Core.settings.put("utimei", this.seconds);
        Core.settings.put("turn", this.turn);
    }

    private void load() {
        this.seconds = Core.settings.getInt("utimei");
        this.turn = Core.settings.getInt("turn");
    }
}

