/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;
import arc.math.Mathf;
import arc.struct.IntSet;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.graphics.CacheLayer;
import mindustry.graphics.FloorRenderer;
import mindustry.graphics.Shaders;
import mindustry.ui.Cicon;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.power.PowerNode;

public class BlockRenderer {
    public static final int crackRegions = 8;
    public static final int maxCrackSize = 9;
    private static final int initialRequests = 1024;
    private static final int expandr = 10;
    private static final Color shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.71f);
    public final FloorRenderer floor = new FloorRenderer();
    public TextureRegion[][] cracks;
    private Seq<Tile> tileview = new Seq(false, 1024, Tile.class);
    private Seq<Tile> lightview = new Seq(false, 1024, Tile.class);
    private int lastCamX;
    private int lastCamY;
    private int lastRangeX;
    private int lastRangeY;
    private float brokenFade = 0.0f;
    private FrameBuffer shadows = new FrameBuffer();
    private FrameBuffer dark = new FrameBuffer();
    private Seq<Building> outArray2 = new Seq();
    private Seq<Tile> shadowEvents = new Seq();
    private IntSet procEntities = new IntSet();
    private IntSet procLinks = new IntSet();
    private IntSet procLights = new IntSet();

    public BlockRenderer() {
        Events.on(EventType.ClientLoadEvent.class, e -> {
            this.cracks = new TextureRegion[9][8];
            for (int size = 1; size <= 9; ++size) {
                for (int i = 0; i < 8; ++i) {
                    this.cracks[size - 1][i] = Core.atlas.find("cracks-" + size + "-" + i);
                }
            }
        });
        Events.on(EventType.WorldLoadEvent.class, event -> {
            this.shadowEvents.clear();
            this.lastCamX = -99;
            this.lastCamY = -99;
            ((Texture)this.shadows.getTexture()).setFilter(Texture.TextureFilter.linear, Texture.TextureFilter.linear);
            this.shadows.resize(Vars.world.width(), Vars.world.height());
            this.shadows.begin();
            Core.graphics.clear(Color.white);
            Draw.proj().setOrtho(0.0f, 0.0f, this.shadows.getWidth(), this.shadows.getHeight());
            Draw.color(shadowColor);
            for (Tile tile : Vars.world.tiles) {
                if (!tile.block().hasShadow) continue;
                Fill.rect((float)tile.x + 0.5f, (float)tile.y + 0.5f, 1.0f, 1.0f);
            }
            Draw.flush();
            Draw.color();
            this.shadows.end();
            ((Texture)this.dark.getTexture()).setFilter(Texture.TextureFilter.linear, Texture.TextureFilter.linear);
            this.dark.resize(Vars.world.width(), Vars.world.height());
            this.dark.begin();
            Core.graphics.clear(Color.white);
            Draw.proj().setOrtho(0.0f, 0.0f, this.dark.getWidth(), this.dark.getHeight());
            for (Tile tile : Vars.world.tiles) {
                float darkness = Vars.world.getDarkness(tile.x, tile.y);
                if (!(darkness > 0.0f)) continue;
                Draw.color(0.0f, 0.0f, 0.0f, Math.min((darkness + 0.5f) / 4.0f, 1.0f));
                Fill.rect((float)tile.x + 0.5f, (float)tile.y + 0.5f, 1.0f, 1.0f);
            }
            Draw.flush();
            Draw.color();
            this.dark.end();
        });
        Events.on(EventType.TileChangeEvent.class, event -> {
            this.shadowEvents.add(event.tile);
            int avgx = (int)(Core.camera.position.x / 8.0f);
            int avgy = (int)(Core.camera.position.y / 8.0f);
            int rangex = (int)(Core.camera.width / 8.0f / 2.0f) + 2;
            int rangey = (int)(Core.camera.height / 8.0f / 2.0f) + 2;
            if (Math.abs(avgx - event.tile.x) <= rangex && Math.abs(avgy - event.tile.y) <= rangey) {
                this.lastCamX = -99;
                this.lastCamY = -99;
            }
        });
    }

    public void drawDarkness() {
        Draw.shader(Shaders.darkness);
        Draw.fbo(this.dark, Vars.world.width(), Vars.world.height(), 8);
        Draw.shader();
    }

    public void drawDestroyed() {
        if (!Core.settings.getBool("destroyedblocks")) {
            return;
        }
        this.brokenFade = Vars.control.input.isPlacing() || Vars.control.input.isBreaking() ? Mathf.lerpDelta(this.brokenFade, 1.0f, 0.1f) : Mathf.lerpDelta(this.brokenFade, 0.0f, 0.1f);
        if (this.brokenFade > 0.001f) {
            for (Teams.BlockPlan block : Vars.state.teams.get((Team)Vars.player.team()).blocks) {
                Block b = Vars.content.block(block.block);
                if (!Core.camera.bounds(Tmp.r1).grow(16.0f).overlaps(Tmp.r2.setSize(b.size * 8).setCenter((float)(block.x * 8) + b.offset, (float)(block.y * 8) + b.offset))) continue;
                Draw.alpha(0.33f * this.brokenFade);
                Draw.mixcol(Color.white, 0.2f + Mathf.absin(Time.globalTime, 6.0f, 0.2f));
                Draw.rect(b.icon(Cicon.full), (float)(block.x * 8) + b.offset, (float)(block.y * 8) + b.offset, b.rotate ? (float)(block.rotation * 90) : 0.0f);
            }
            Draw.reset();
        }
    }

    public void drawShadows() {
        if (!this.shadowEvents.isEmpty()) {
            Draw.flush();
            this.shadows.begin();
            Draw.proj().setOrtho(0.0f, 0.0f, this.shadows.getWidth(), this.shadows.getHeight());
            for (Tile tile : this.shadowEvents) {
                Draw.color(Color.white);
                Fill.rect((float)tile.x + 0.5f, (float)tile.y + 0.5f, 1.0f, 1.0f);
                Draw.color(!tile.block().hasShadow ? Color.white : shadowColor);
                Fill.rect((float)tile.x + 0.5f, (float)tile.y + 0.5f, 1.0f, 1.0f);
            }
            Draw.flush();
            Draw.color();
            this.shadows.end();
            this.shadowEvents.clear();
            Draw.proj(Core.camera);
        }
        float ww = Vars.world.width() * 8;
        float wh = Vars.world.height() * 8;
        float x = Core.camera.position.x + 4.0f;
        float y = Core.camera.position.y + 4.0f;
        float u = (x - Core.camera.width / 2.0f) / ww;
        float v = (y - Core.camera.height / 2.0f) / wh;
        float u2 = (x + Core.camera.width / 2.0f) / ww;
        float v2 = (y + Core.camera.height / 2.0f) / wh;
        Tmp.tr1.set((Texture)this.shadows.getTexture());
        Tmp.tr1.set(u, v2, u2, v);
        Draw.shader(Shaders.darkness);
        Draw.rect(Tmp.tr1, Core.camera.position.x, Core.camera.position.y, Core.camera.width, Core.camera.height);
        Draw.shader();
    }

    public void processBlocks() {
        int avgx = (int)(Core.camera.position.x / 8.0f);
        int avgy = (int)(Core.camera.position.y / 8.0f);
        int rangex = (int)(Core.camera.width / 8.0f / 2.0f) + 3;
        int rangey = (int)(Core.camera.height / 8.0f / 2.0f) + 3;
        if (avgx == this.lastCamX && avgy == this.lastCamY && this.lastRangeX == rangex && this.lastRangeY == rangey) {
            return;
        }
        this.tileview.clear();
        this.lightview.clear();
        this.procEntities.clear();
        this.procLinks.clear();
        this.procLights.clear();
        int minx = Math.max(avgx - rangex - 10, 0);
        int miny = Math.max(avgy - rangey - 10, 0);
        int maxx = Math.min(Vars.world.width() - 1, avgx + rangex + 10);
        int maxy = Math.min(Vars.world.height() - 1, avgy + rangey + 10);
        for (int x = minx; x <= maxx; ++x) {
            for (int y = miny; y <= maxy; ++y) {
                boolean expanded = Math.abs(x - avgx) > rangex || Math.abs(y - avgy) > rangey;
                Tile tile = Vars.world.rawTile(x, y);
                Block block = tile.block();
                if (tile.build != null) {
                    tile = tile.build.tile;
                }
                if (!(block == Blocks.air || block.cacheLayer != CacheLayer.normal || tile.build != null && this.procEntities.contains(tile.build.id))) {
                    if (!(!block.expanded && expanded || tile.build != null && !this.procLinks.add(tile.build.id))) {
                        this.tileview.add(tile);
                        if (tile.build != null) {
                            this.procEntities.add(tile.build.id);
                            this.procLinks.add(tile.build.id);
                        }
                    }
                    if (tile.build != null && this.procLights.add(tile.build.pos()) || tile.block().emitLight) {
                        this.lightview.add(tile);
                    }
                    if (tile.build != null && tile.build.power != null && tile.build.power.links.size > 0) {
                        for (Building other : tile.build.getPowerConnections(this.outArray2)) {
                            if (!(other.block instanceof PowerNode) || !this.procLinks.add(other.id)) continue;
                            this.tileview.add(other.tile);
                        }
                    }
                }
                if (block != Blocks.air || !tile.floor().emitLight || !this.procLights.add(tile.pos())) continue;
                this.lightview.add(tile);
            }
        }
        this.lastCamX = avgx;
        this.lastCamY = avgy;
        this.lastRangeX = rangex;
        this.lastRangeY = rangey;
    }

    public void drawBlocks() {
        Tile tile;
        int i;
        this.drawDestroyed();
        for (i = 0; i < this.tileview.size; ++i) {
            tile = ((Tile[])this.tileview.items)[i];
            Block block = tile.block();
            Building entity = tile.build;
            Draw.z(30.0f);
            if (block == Blocks.air) continue;
            block.drawBase(tile);
            Draw.reset();
            Draw.z(30.0f);
            if (entity != null) {
                if (entity.damaged()) {
                    entity.drawCracks();
                    Draw.z(30.0f);
                }
                if (entity.team != Vars.player.team()) {
                    entity.drawTeam();
                    Draw.z(30.0f);
                }
                if (Vars.renderer.drawStatus && block.consumes.any()) {
                    entity.drawStatus();
                }
            }
            Draw.reset();
        }
        if (Vars.renderer.lights.enabled()) {
            for (i = 0; i < this.lightview.size; ++i) {
                tile = ((Tile[])this.lightview.items)[i];
                Building entity = tile.build;
                if (entity != null) {
                    entity.drawLight();
                    continue;
                }
                if (tile.block().emitLight) {
                    tile.block().drawEnvironmentLight(tile);
                    continue;
                }
                if (!tile.floor().emitLight || tile.block().solid || !(Vars.world.getDarkness(tile.x, tile.y) < 3.0f)) continue;
                tile.floor().drawEnvironmentLight(tile);
            }
        }
    }
}

