/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.gl.Shader;
import mindustry.Vars;
import mindustry.graphics.Shaders;

public enum CacheLayer {
    water{

        @Override
        public void begin() {
            this.beginShader();
        }

        @Override
        public void end() {
            this.endShader(Shaders.water);
        }
    }
    ,
    mud{

        @Override
        public void begin() {
            this.beginShader();
        }

        @Override
        public void end() {
            this.endShader(Shaders.mud);
        }
    }
    ,
    tar{

        @Override
        public void begin() {
            this.beginShader();
        }

        @Override
        public void end() {
            this.endShader(Shaders.tar);
        }
    }
    ,
    slag{

        @Override
        public void begin() {
            this.beginShader();
        }

        @Override
        public void end() {
            this.endShader(Shaders.slag);
        }
    }
    ,
    space{

        @Override
        public void begin() {
            this.beginShader();
        }

        @Override
        public void end() {
            this.endShader(Shaders.space);
        }
    }
    ,
    normal,
    walls;

    public static final CacheLayer[] all;

    public void begin() {
    }

    public void end() {
    }

    void beginShader() {
        if (!Core.settings.getBool("animatedwater")) {
            return;
        }
        Vars.renderer.blocks.floor.endc();
        Vars.renderer.effectBuffer.begin();
        Core.graphics.clear(Color.clear);
        Vars.renderer.blocks.floor.beginc();
    }

    void endShader(Shader shader) {
        if (!Core.settings.getBool("animatedwater")) {
            return;
        }
        Vars.renderer.blocks.floor.endc();
        Vars.renderer.effectBuffer.end();
        Vars.renderer.effectBuffer.blit(shader);
        Vars.renderer.blocks.floor.beginc();
    }

    static {
        all = CacheLayer.values();
    }
}

