/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.graphics.Shaders;
import mindustry.ui.Cicon;
import mindustry.world.Block;
import mindustry.world.Tile;

public class Drawf {
    public static void target(float x, float y, float rad, Color color) {
        Drawf.target(x, y, rad, 1.0f, color);
    }

    public static void target(float x, float y, float rad, float alpha, Color color) {
        Lines.stroke(3.0f);
        Draw.color(Pal.gray, alpha);
        Lines.poly(x, y, 4, rad, Time.time * 1.5f);
        Lines.spikes(x, y, 0.42857143f * rad, 0.85714287f * rad, 4, Time.time * 1.5f);
        Lines.stroke(1.0f);
        Draw.color(color, alpha);
        Lines.poly(x, y, 4, rad, Time.time * 1.5f);
        Lines.spikes(x, y, 0.42857143f * rad, 0.85714287f * rad, 4, Time.time * 1.5f);
        Draw.reset();
    }

    public static float text() {
        float z = Draw.z();
        if (Vars.renderer.pixelator.enabled()) {
            Draw.z(210.0f);
        }
        return z;
    }

    public static void light(float x, float y, float radius, Color color, float opacity) {
        Vars.renderer.lights.add(x, y, radius, color, opacity);
    }

    public static void light(Team team, float x, float y, float radius, Color color, float opacity) {
        if (Drawf.allowLight(team)) {
            Vars.renderer.lights.add(x, y, radius, color, opacity);
        }
    }

    public static void light(Team team, Position pos, float radius, Color color, float opacity) {
        Drawf.light(team, pos.getX(), pos.getY(), radius, color, opacity);
    }

    public static void light(Team team, float x, float y, TextureRegion region, Color color, float opacity) {
        if (Drawf.allowLight(team)) {
            Vars.renderer.lights.add(x, y, region, color, opacity);
        }
    }

    public static void light(Team team, float x, float y, float x2, float y2) {
        if (Drawf.allowLight(team)) {
            Vars.renderer.lights.line(x, y, x2, y2, 30.0f, Color.orange, 0.3f);
        }
    }

    public static void light(Team team, float x, float y, float x2, float y2, float stroke, Color tint, float alpha) {
        if (Drawf.allowLight(team)) {
            Vars.renderer.lights.line(x, y, x2, y2, stroke, tint, alpha);
        }
    }

    private static boolean allowLight(Team team) {
        return Vars.renderer != null && (team == Team.derelict || team == Vars.player.team() || Vars.state.rules.enemyLights);
    }

    public static void selected(Building tile, Color color) {
        Drawf.selected(tile.tile(), color);
    }

    public static void selected(Tile tile, Color color) {
        Drawf.selected(tile.x, tile.y, tile.block(), color);
    }

    public static void selected(int x, int y, Block block, Color color) {
        Draw.color(color);
        for (int i = 0; i < 4; ++i) {
            Point2 p = Geometry.d8edge[i];
            float offset = (float)(-Math.max(block.size - 1, 0)) / 2.0f * 8.0f;
            Draw.rect("block-select", (float)(x * 8) + block.offset + offset * (float)p.x, (float)(y * 8) + block.offset + offset * (float)p.y, (float)(i * 90));
        }
        Draw.reset();
    }

    public static void shadow(float x, float y, float rad) {
        Drawf.shadow(x, y, rad, 1.0f);
    }

    public static void shadow(float x, float y, float rad, float alpha) {
        Draw.color(0.0f, 0.0f, 0.0f, 0.4f * alpha);
        Draw.rect("circle-shadow", x, y, rad, rad);
        Draw.color();
    }

    public static void shadow(TextureRegion region, float x, float y, float rotation) {
        Draw.color(Pal.shadow);
        Draw.rect(region, x, y, rotation);
        Draw.color();
    }

    public static void shadow(TextureRegion region, float x, float y) {
        Draw.color(Pal.shadow);
        Draw.rect(region, x, y);
        Draw.color();
    }

    public static void shadow(TextureRegion region, float x, float y, float width, float height, float rotation) {
        Draw.color(Pal.shadow);
        Draw.rect(region, x, y, width, height, rotation);
        Draw.color();
    }

    public static void liquid(TextureRegion region, float x, float y, float alpha, Color color, float rotation) {
        Draw.color(color, alpha);
        Draw.rect(region, x, y, rotation);
        Draw.color();
    }

    public static void liquid(TextureRegion region, float x, float y, float alpha, Color color) {
        Draw.color(color, alpha);
        Draw.rect(region, x, y);
        Draw.color();
    }

    public static void dashCircle(float x, float y, float rad, Color color) {
        Lines.stroke(3.0f, Pal.gray);
        Lines.dashCircle(x, y, rad);
        Lines.stroke(1.0f, color);
        Lines.dashCircle(x, y, rad);
        Draw.reset();
    }

    public static void circles(float x, float y, float rad) {
        Drawf.circles(x, y, rad, Pal.accent);
    }

    public static void circles(float x, float y, float rad, Color color) {
        Lines.stroke(3.0f, Pal.gray);
        Lines.circle(x, y, rad);
        Lines.stroke(1.0f, color);
        Lines.circle(x, y, rad);
        Draw.reset();
    }

    public static void select(float x, float y, float radius, Color color) {
        Lines.stroke(3.0f, Pal.gray);
        Lines.square(x, y, radius + 1.0f);
        Lines.stroke(1.0f, color);
        Lines.square(x, y, radius);
        Draw.reset();
    }

    public static void square(float x, float y, float radius, float rotation, Color color) {
        Lines.stroke(3.0f, Pal.gray);
        Lines.square(x, y, radius + 1.0f, rotation);
        Lines.stroke(1.0f, color);
        Lines.square(x, y, radius + 1.0f, rotation);
        Draw.reset();
    }

    public static void square(float x, float y, float radius, float rotation) {
        Drawf.square(x, y, radius, rotation, Pal.accent);
    }

    public static void square(float x, float y, float radius, Color color) {
        Drawf.square(x, y, radius, 45.0f, color);
    }

    public static void square(float x, float y, float radius) {
        Drawf.square(x, y, radius, 45.0f);
    }

    public static void arrow(float x, float y, float x2, float y2, float length, float radius) {
        Drawf.arrow(x, y, x2, y2, length, radius, Pal.accent);
    }

    public static void arrow(float x, float y, float x2, float y2, float length, float radius, Color color) {
        float angle = Angles.angle(x, y, x2, y2);
        float space = 2.0f;
        Tmp.v1.set(x2, y2).sub(x, y).limit(length);
        float vx = Tmp.v1.x + x;
        float vy = Tmp.v1.y + y;
        Draw.color(Pal.gray);
        Fill.poly(vx, vy, 3, radius + space, angle);
        Draw.color(color);
        Fill.poly(vx, vy, 3, radius, angle);
        Draw.color();
    }

    public static void laser(Team team, TextureRegion line, TextureRegion edge, float x, float y, float x2, float y2, float scale) {
        Drawf.laser(team, line, edge, x, y, x2, y2, Mathf.angle(x2 - x, y2 - y), scale);
    }

    public static void laser(Team team, TextureRegion line, TextureRegion edge, float x, float y, float x2, float y2) {
        Drawf.laser(team, line, edge, x, y, x2, y2, Mathf.angle(x2 - x, y2 - y), 1.0f);
    }

    public static void laser(Team team, TextureRegion line, TextureRegion edge, float x, float y, float x2, float y2, float rotation, float scale) {
        float scl = 8.0f * scale * Draw.scl;
        float vx = Mathf.cosDeg(rotation) * scl;
        float vy = Mathf.sinDeg(rotation) * scl;
        Draw.rect(edge, x, y, (float)edge.width * scale * Draw.scl, (float)edge.height * scale * Draw.scl, rotation + 180.0f);
        Draw.rect(edge, x2, y2, (float)edge.width * scale * Draw.scl, (float)edge.height * scale * Draw.scl, rotation);
        Lines.stroke(12.0f * scale);
        Lines.line(line, x + vx, y + vy, x2 - vx, y2 - vy, false);
        Lines.stroke(1.0f);
        Drawf.light(team, x, y, x2, y2);
    }

    public static void tri(float x, float y, float width, float length, float rotation) {
        float oy = 0.26984128f * length;
        Draw.rect(Core.atlas.find("shape-3"), x, y - oy + length / 2.0f, width, length, width / 2.0f, oy, rotation - 90.0f);
    }

    public static void construct(Building t, UnlockableContent content, float rotation, float progress, float speed, float time) {
        Drawf.construct(t, content.icon(Cicon.full), rotation, progress, speed, time);
    }

    public static void construct(float x, float y, TextureRegion region, float rotation, float progress, float speed, float time) {
        Drawf.construct(x, y, region, Pal.accent, rotation, progress, speed, time);
    }

    public static void construct(float x, float y, TextureRegion region, Color color, float rotation, float progress, float speed, float time) {
        Shaders.build.region = region;
        Shaders.build.progress = progress;
        Shaders.build.color.set(color);
        Shaders.build.color.a = speed;
        Shaders.build.time = -time / 20.0f;
        Draw.shader(Shaders.build);
        Draw.rect(region, x, y, rotation);
        Draw.shader();
        Draw.reset();
    }

    public static void construct(Building t, TextureRegion region, float rotation, float progress, float speed, float time) {
        Drawf.construct(t, region, Pal.accent, rotation, progress, speed, time);
    }

    public static void construct(Building t, TextureRegion region, Color color, float rotation, float progress, float speed, float time) {
        Shaders.build.region = region;
        Shaders.build.progress = progress;
        Shaders.build.color.set(color);
        Shaders.build.color.a = speed;
        Shaders.build.time = -time / 20.0f;
        Draw.shader(Shaders.build);
        Draw.rect(region, t.x, t.y, rotation);
        Draw.shader();
        Draw.color(Pal.accent);
        Draw.alpha(speed);
        Lines.lineAngleCenter(t.x + Mathf.sin(time, 20.0f, 4.0f * (float)t.block.size - 2.0f), t.y, 90.0f, (float)(t.block.size * 8) - 4.0f);
        Draw.reset();
    }
}

