/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.Events;
import arc.graphics.Camera;
import arc.graphics.Gl;
import arc.graphics.g2d.Batch;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.MultiCacheBatch;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.struct.IntSeq;
import arc.struct.IntSet;
import arc.struct.ObjectSet;
import arc.util.Disposable;
import arc.util.Log;
import arc.util.Structs;
import arc.util.Time;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.graphics.CacheLayer;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;

public class FloorRenderer
implements Disposable {
    private static final int chunksize = Vars.mobile ? 16 : 32;
    private static final int chunkunits = chunksize * 8;
    private static final float pad = 4.0f;
    private int[][][] cache;
    private MultiCacheBatch cbatch;
    private IntSet drawnLayerSet = new IntSet();
    private IntSet recacheSet = new IntSet();
    private IntSeq drawnLayers = new IntSeq();
    private ObjectSet<CacheLayer> used = new ObjectSet();

    public FloorRenderer() {
        Events.on(EventType.WorldLoadEvent.class, event -> this.clearTiles());
    }

    public void recacheTile(Tile tile) {
    }

    public void drawFloor() {
        if (this.cache == null) {
            return;
        }
        Camera camera = Core.camera;
        int minx = (int)((camera.position.x - camera.width / 2.0f - 4.0f) / (float)chunkunits);
        int miny = (int)((camera.position.y - camera.height / 2.0f - 4.0f) / (float)chunkunits);
        int maxx = Mathf.ceil((camera.position.x + camera.width / 2.0f + 4.0f) / (float)chunkunits);
        int maxy = Mathf.ceil((camera.position.y + camera.height / 2.0f + 4.0f) / (float)chunkunits);
        int layers = CacheLayer.all.length;
        this.drawnLayers.clear();
        this.drawnLayerSet.clear();
        for (int x = minx; x <= maxx; ++x) {
            for (int y = miny; y <= maxy; ++y) {
                if (!Structs.inBounds(x, y, this.cache)) continue;
                int[] chunk = this.cache[x][y];
                for (int i = 0; i < layers; ++i) {
                    if (chunk[i] == -1 || i == CacheLayer.walls.ordinal()) continue;
                    this.drawnLayerSet.add(i);
                }
            }
        }
        IntSet.IntSetIterator it = this.drawnLayerSet.iterator();
        while (it.hasNext) {
            this.drawnLayers.add(it.next());
        }
        this.drawnLayers.sort();
        Draw.flush();
        this.beginDraw();
        for (int i = 0; i < this.drawnLayers.size; ++i) {
            CacheLayer layer = CacheLayer.all[this.drawnLayers.get(i)];
            this.drawLayer(layer);
        }
        this.endDraw();
    }

    public void beginc() {
        this.cbatch.beginDraw();
    }

    public void endc() {
        this.cbatch.endDraw();
    }

    public void checkChanges() {
        if (this.recacheSet.size > 0) {
            IntSet.IntSetIterator iterator = this.recacheSet.iterator();
            while (iterator.hasNext) {
                int chunk = iterator.next();
                this.cacheChunk(Point2.x(chunk), Point2.y(chunk));
            }
            this.recacheSet.clear();
        }
    }

    public void beginDraw() {
        if (this.cache == null) {
            return;
        }
        Draw.flush();
        this.cbatch.setProjection(Core.camera.mat);
        this.cbatch.beginDraw();
        Gl.enable(3042);
    }

    public void endDraw() {
        if (this.cache == null) {
            return;
        }
        this.cbatch.endDraw();
    }

    public void drawLayer(CacheLayer layer) {
        if (this.cache == null) {
            return;
        }
        Camera camera = Core.camera;
        int minx = (int)((camera.position.x - camera.width / 2.0f - 4.0f) / (float)chunkunits);
        int miny = (int)((camera.position.y - camera.height / 2.0f - 4.0f) / (float)chunkunits);
        int maxx = Mathf.ceil((camera.position.x + camera.width / 2.0f + 4.0f) / (float)chunkunits);
        int maxy = Mathf.ceil((camera.position.y + camera.height / 2.0f + 4.0f) / (float)chunkunits);
        layer.begin();
        for (int x = minx; x <= maxx; ++x) {
            for (int y = miny; y <= maxy; ++y) {
                int[] chunk;
                if (!Structs.inBounds(x, y, this.cache) || (chunk = this.cache[x][y])[layer.ordinal()] == -1) continue;
                this.cbatch.drawCache(chunk[layer.ordinal()]);
            }
        }
        layer.end();
    }

    private void cacheChunk(int cx, int cy) {
        this.used.clear();
        int[] chunk = this.cache[cx][cy];
        for (int tilex = cx * chunksize; tilex < (cx + 1) * chunksize && tilex < Vars.world.width(); ++tilex) {
            for (int tiley = cy * chunksize; tiley < (cy + 1) * chunksize && tiley < Vars.world.height(); ++tiley) {
                Tile tile = Vars.world.rawTile(tilex, tiley);
                if (tile.block().cacheLayer != CacheLayer.normal) {
                    this.used.add(tile.block().cacheLayer);
                    continue;
                }
                this.used.add(tile.floor().cacheLayer);
            }
        }
        for (CacheLayer layer : this.used) {
            this.cacheChunkLayer(cx, cy, chunk, layer);
        }
    }

    private void cacheChunkLayer(int cx, int cy, int[] chunk, CacheLayer layer) {
        Batch current = Core.batch;
        Core.batch = this.cbatch;
        if (chunk[layer.ordinal()] == -1) {
            this.cbatch.beginCache();
        } else {
            this.cbatch.beginCache(chunk[layer.ordinal()]);
        }
        for (int tilex = cx * chunksize; tilex < (cx + 1) * chunksize; ++tilex) {
            for (int tiley = cy * chunksize; tiley < (cy + 1) * chunksize; ++tiley) {
                Tile tile = Vars.world.tile(tilex, tiley);
                if (tile == null) continue;
                Floor floor = tile.floor();
                if (!(tile.block().cacheLayer != layer || layer != CacheLayer.walls || tile.isDarkened() && tile.data >= 5)) {
                    tile.block().drawBase(tile);
                    continue;
                }
                if (floor.cacheLayer == layer && (Vars.world.isAccessible(tile.x, tile.y) || tile.block().cacheLayer != CacheLayer.walls || !tile.block().fillsTile)) {
                    floor.drawBase(tile);
                    continue;
                }
                if (floor.cacheLayer == layer || layer == CacheLayer.walls) continue;
                floor.drawNonLayer(tile, layer);
            }
        }
        Core.batch = current;
        chunk[layer.ordinal()] = this.cbatch.endCache();
    }

    public void clearTiles() {
        if (this.cbatch != null) {
            this.cbatch.dispose();
        }
        this.recacheSet.clear();
        int chunksx = Mathf.ceil((float)Vars.world.width() / (float)chunksize);
        int chunksy = Mathf.ceil((float)Vars.world.height() / (float)chunksize);
        this.cache = new int[chunksx][chunksy][CacheLayer.all.length];
        this.cbatch = new MultiCacheBatch(chunksize * chunksize * 9);
        Time.mark();
        for (int x = 0; x < chunksx; ++x) {
            for (int y = 0; y < chunksy; ++y) {
                Arrays.fill(this.cache[x][y], -1);
                this.cacheChunk(x, y);
            }
        }
        Log.debug("Time to cache: @", Float.valueOf(Time.elapsed()));
    }

    @Override
    public void dispose() {
        if (this.cbatch != null) {
            this.cbatch.dispose();
            this.cbatch = null;
        }
    }
}

