/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.Gl;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.graphics.Shaders;

public class LightRenderer {
    private static final int scaling = 4;
    private float[] vertices = new float[24];
    private FrameBuffer buffer = new FrameBuffer();
    private Seq<Runnable> lights = new Seq();

    public void add(Runnable run) {
        if (!this.enabled()) {
            return;
        }
        this.lights.add(run);
    }

    public void add(float x, float y, float radius, Color color, float opacity) {
        if (!this.enabled()) {
            return;
        }
        float res = color.toFloatBits();
        this.add(() -> {
            Draw.color(res);
            Draw.alpha(opacity);
            Draw.rect("circle-shadow", x, y, radius * 2.0f, radius * 2.0f);
        });
    }

    public void add(float x, float y, TextureRegion region, Color color, float opacity) {
        if (!this.enabled()) {
            return;
        }
        float res = color.toFloatBits();
        this.add(() -> {
            Draw.color(res);
            Draw.alpha(opacity);
            Draw.rect(region, x, y);
        });
    }

    public void line(float x, float y, float x2, float y2, float stroke, Color tint, float alpha) {
        if (!this.enabled()) {
            return;
        }
        this.add(() -> {
            Draw.color(tint, alpha);
            float rot = Mathf.angleExact(x2 - x, y2 - y);
            TextureAtlas.AtlasRegion ledge = Core.atlas.find("circle-end");
            TextureAtlas.AtlasRegion lmid = Core.atlas.find("circle-mid");
            float color = Draw.getColor().toFloatBits();
            float u = lmid.u;
            float v = lmid.v2;
            float u2 = lmid.u2;
            float v2 = lmid.v;
            Vec2 v1 = Tmp.v1.trnsExact(rot + 90.0f, stroke);
            float lx1 = x - v1.x;
            float ly1 = y - v1.y;
            float lx2 = x + v1.x;
            float ly2 = y + v1.y;
            float lx3 = x2 + v1.x;
            float ly3 = y2 + v1.y;
            float lx4 = x2 - v1.x;
            float ly4 = y2 - v1.y;
            this.vertices[0] = lx1;
            this.vertices[1] = ly1;
            this.vertices[2] = color;
            this.vertices[3] = u;
            this.vertices[4] = v;
            this.vertices[5] = 0.0f;
            this.vertices[6] = lx2;
            this.vertices[7] = ly2;
            this.vertices[8] = color;
            this.vertices[9] = u;
            this.vertices[10] = v2;
            this.vertices[11] = 0.0f;
            this.vertices[12] = lx3;
            this.vertices[13] = ly3;
            this.vertices[14] = color;
            this.vertices[15] = u2;
            this.vertices[16] = v2;
            this.vertices[17] = 0.0f;
            this.vertices[18] = lx4;
            this.vertices[19] = ly4;
            this.vertices[20] = color;
            this.vertices[21] = u2;
            this.vertices[22] = v;
            this.vertices[23] = 0.0f;
            Draw.vert(ledge.texture, this.vertices, 0, this.vertices.length);
            Vec2 v3 = Tmp.v2.trnsExact(rot, stroke);
            u = ledge.u;
            v = ledge.v2;
            u2 = ledge.u2;
            v2 = ledge.v;
            this.vertices[0] = lx4;
            this.vertices[1] = ly4;
            this.vertices[2] = color;
            this.vertices[3] = u;
            this.vertices[4] = v;
            this.vertices[5] = 0.0f;
            this.vertices[6] = lx3;
            this.vertices[7] = ly3;
            this.vertices[8] = color;
            this.vertices[9] = u;
            this.vertices[10] = v2;
            this.vertices[11] = 0.0f;
            this.vertices[12] = lx3 + v3.x;
            this.vertices[13] = ly3 + v3.y;
            this.vertices[14] = color;
            this.vertices[15] = u2;
            this.vertices[16] = v2;
            this.vertices[17] = 0.0f;
            this.vertices[18] = lx4 + v3.x;
            this.vertices[19] = ly4 + v3.y;
            this.vertices[20] = color;
            this.vertices[21] = u2;
            this.vertices[22] = v;
            this.vertices[23] = 0.0f;
            Draw.vert(ledge.texture, this.vertices, 0, this.vertices.length);
            this.vertices[0] = lx2;
            this.vertices[1] = ly2;
            this.vertices[2] = color;
            this.vertices[3] = u;
            this.vertices[4] = v;
            this.vertices[5] = 0.0f;
            this.vertices[6] = lx1;
            this.vertices[7] = ly1;
            this.vertices[8] = color;
            this.vertices[9] = u;
            this.vertices[10] = v2;
            this.vertices[11] = 0.0f;
            this.vertices[12] = lx1 - v3.x;
            this.vertices[13] = ly1 - v3.y;
            this.vertices[14] = color;
            this.vertices[15] = u2;
            this.vertices[16] = v2;
            this.vertices[17] = 0.0f;
            this.vertices[18] = lx2 - v3.x;
            this.vertices[19] = ly2 - v3.y;
            this.vertices[20] = color;
            this.vertices[21] = u2;
            this.vertices[22] = v;
            this.vertices[23] = 0.0f;
            Draw.vert(ledge.texture, this.vertices, 0, this.vertices.length);
        });
    }

    public boolean enabled() {
        return Vars.state.rules.lighting && Vars.state.rules.ambientLight.a > 1.0E-5f;
    }

    public void draw() {
        if (!Vars.enableLight) {
            this.lights.clear();
            return;
        }
        this.buffer.resize(Core.graphics.getWidth() / 4, Core.graphics.getHeight() / 4);
        Draw.color();
        this.buffer.begin(Color.clear);
        Gl.blendEquationSeparate(32774, 32776);
        for (Runnable run : this.lights) {
            run.run();
        }
        Draw.reset();
        this.buffer.end();
        Gl.blendEquationSeparate(32774, 32774);
        Draw.color();
        Shaders.light.ambient.set(Vars.state.rules.ambientLight);
        this.buffer.blit(Shaders.light);
        this.lights.clear();
    }
}

