/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.scene.ui.layout.Scl;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Tmp;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.entities.Units;
import mindustry.game.EventType;
import mindustry.gen.Groups;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.io.MapIO;
import mindustry.ui.Cicon;
import mindustry.ui.Fonts;
import mindustry.world.Tile;

public class MinimapRenderer {
    private static final float baseSize = 16.0f;
    private final Seq<Unit> units = new Seq();
    private Pixmap pixmap;
    private Texture texture;
    private TextureRegion region;
    private Rect rect = new Rect();
    private float zoom = 4.0f;

    public MinimapRenderer() {
        Events.on(EventType.WorldLoadEvent.class, event -> {
            this.reset();
            this.updateAll();
        });
        Events.on(EventType.TileChangeEvent.class, event -> {
            if (!Vars.ui.editor.isShown()) {
                this.update(event.tile);
            }
        });
    }

    public Pixmap getPixmap() {
        return this.pixmap;
    }

    @Nullable
    public Texture getTexture() {
        return this.texture;
    }

    public void zoomBy(float amount) {
        this.zoom += amount;
        this.setZoom(this.zoom);
    }

    public void setZoom(float amount) {
        this.zoom = Mathf.clamp(amount, 1.0f, (float)Math.min(Vars.world.width(), Vars.world.height()) / 16.0f / 2.0f);
    }

    public float getZoom() {
        return this.zoom;
    }

    public void reset() {
        if (this.pixmap != null) {
            this.pixmap.dispose();
            this.texture.dispose();
        }
        this.setZoom(4.0f);
        this.pixmap = new Pixmap(Vars.world.width(), Vars.world.height(), Pixmap.Format.rgba8888);
        this.texture = new Texture(this.pixmap);
        this.region = new TextureRegion(this.texture);
    }

    public void drawEntities(float x, float y, float w, float h, float scaling, boolean withLabels) {
        float ry;
        float rx;
        if (!withLabels) {
            this.updateUnitArray();
        } else {
            this.units.clear();
            Groups.unit.each(this.units::add);
        }
        float sz = 16.0f * this.zoom;
        float dx = Core.camera.position.x / 8.0f;
        float dy = Core.camera.position.y / 8.0f;
        dx = Mathf.clamp(dx, sz, (float)Vars.world.width() - sz);
        dy = Mathf.clamp(dy, sz, (float)Vars.world.height() - sz);
        this.rect.set((dx - sz) * 8.0f, (dy - sz) * 8.0f, sz * 2.0f * 8.0f, sz * 2.0f * 8.0f);
        for (Unit unit : this.units) {
            rx = !withLabels ? (unit.x - this.rect.x) / this.rect.width * w : unit.x / (float)(Vars.world.width() * 8) * w;
            ry = !withLabels ? (unit.y - this.rect.y) / this.rect.width * h : unit.y / (float)(Vars.world.height() * 8) * h;
            Draw.mixcol(unit.team().color, 1.0f);
            float scale = Scl.scl(1.0f) / 2.0f * scaling * 32.0f;
            TextureRegion region = unit.type.icon(Cicon.full);
            Draw.rect(region, x + rx, y + ry, scale, scale * (float)region.height / (float)region.width, unit.rotation() - 90.0f);
            Draw.reset();
        }
        if (withLabels && Vars.net.active()) {
            for (Player player : Groups.player) {
                if (player.dead()) continue;
                rx = player.x / (float)(Vars.world.width() * 8) * w;
                ry = player.y / (float)(Vars.world.height() * 8) * h;
                this.drawLabel(x + rx, y + ry, player.name, player.team().color);
            }
        }
        Draw.reset();
    }

    public void drawEntities(float x, float y, float w, float h) {
        this.drawEntities(x, y, w, h, 1.0f, true);
    }

    @Nullable
    public TextureRegion getRegion() {
        if (this.texture == null) {
            return null;
        }
        float sz = Mathf.clamp(16.0f * this.zoom, 16.0f, (float)Math.min(Vars.world.width(), Vars.world.height()));
        float dx = Core.camera.position.x / 8.0f;
        float dy = Core.camera.position.y / 8.0f;
        dx = Mathf.clamp(dx, sz, (float)Vars.world.width() - sz);
        dy = Mathf.clamp(dy, sz, (float)Vars.world.height() - sz);
        float invTexWidth = 1.0f / (float)this.texture.width;
        float invTexHeight = 1.0f / (float)this.texture.height;
        float x = dx - sz;
        float y = (float)Vars.world.height() - dy - sz;
        float width = sz * 2.0f;
        float height = sz * 2.0f;
        this.region.set(x * invTexWidth, y * invTexHeight, (x + width) * invTexWidth, (y + height) * invTexHeight);
        return this.region;
    }

    public void updateAll() {
        for (Tile tile : Vars.world.tiles) {
            this.pixmap.draw((int)tile.x, this.pixmap.getHeight() - 1 - tile.y, this.colorFor(tile));
        }
        this.texture.draw(this.pixmap);
    }

    public void update(Tile tile) {
        if (Vars.world.isGenerating() || !Vars.state.isGame()) {
            return;
        }
        int color = this.colorFor(Vars.world.tile(tile.x, tile.y));
        this.pixmap.draw((int)tile.x, this.pixmap.getHeight() - 1 - tile.y, color);
        Pixmaps.drawPixel(this.texture, tile.x, this.pixmap.getHeight() - 1 - tile.y, color);
    }

    public void updateUnitArray() {
        float sz = 16.0f * this.zoom;
        float dx = Core.camera.position.x / 8.0f;
        float dy = Core.camera.position.y / 8.0f;
        dx = Mathf.clamp(dx, sz, (float)Vars.world.width() - sz);
        dy = Mathf.clamp(dy, sz, (float)Vars.world.height() - sz);
        this.units.clear();
        Units.nearby((dx - sz) * 8.0f, (dy - sz) * 8.0f, sz * 2.0f * 8.0f, sz * 2.0f * 8.0f, this.units::add);
    }

    private int colorFor(Tile tile) {
        if (tile == null) {
            return 0;
        }
        int bc = tile.block().minimapColor(tile);
        Color color = Tmp.c1.set(bc == 0 ? MapIO.colorFor(tile.block(), tile.floor(), tile.overlay(), tile.team()) : bc);
        color.mul(1.0f - Mathf.clamp(Vars.world.getDarkness(tile.x, tile.y) / 4.0f));
        return color.rgba();
    }

    public void drawLabel(float x, float y, String text, Color color) {
        Font font = Fonts.outline;
        GlyphLayout l = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        boolean ints = font.usesIntegerPositions();
        font.getData().setScale(0.6666667f / Scl.scl(1.0f));
        font.setUseIntegerPositions(false);
        l.setText(font, text, color, 90.0f, 8, true);
        float yOffset = 20.0f;
        float margin = 3.0f;
        Draw.color(0.0f, 0.0f, 0.0f, 0.2f);
        Fill.rect(x, y + yOffset - l.height / 2.0f, l.width + margin, l.height + margin);
        Draw.color();
        font.setColor(color);
        font.draw(text, x - l.width / 2.0f, y + yOffset, 90.0f, 8, true);
        font.setUseIntegerPositions(ints);
        font.getData().setScale(1.0f);
        Pools.free(l);
    }
}

